/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;
import org.mule.datasense.api.metadataprovider.CompatibleComponentAst;
import org.mule.datasense.enrichment.model.IdComponentModelSelector;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.tooling.client.api.datasense.ImmutableMetadataCacheKeyInfo;
import org.mule.tooling.client.api.datasense.ImmutableMetadataResult;
import org.mule.tooling.client.api.datasense.MetadataCache;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.serialization.KryoFactory;

public class LegacyToolingMetadataCache
implements MetadataCache {
    private final LazyValue<ApplicationModel> applicationModel;
    private final Map<String, String> toolingArtifactProperties;
    private final org.mule.tooling.client.api.datasense.MetadataCache delegate;
    private Kryo kryoSerializer;

    public LegacyToolingMetadataCache(LazyValue<ApplicationModel> applicationModel, Map<String, String> toolingArtifactProperties, org.mule.tooling.client.api.datasense.MetadataCache delegate) {
        this.applicationModel = applicationModel;
        this.toolingArtifactProperties = toolingArtifactProperties;
        this.delegate = delegate;
        this.kryoSerializer = KryoFactory.defaultKryo();
    }

    @Override
    public MetadataResult<OperationModel> getOperationMetadata(CompatibleComponentAst componentAst, Callable<MetadataResult<OperationModel>> resolver) {
        ComponentModel componentModel = this.getComponentModel(componentAst);
        return (MetadataResult)this.deserialize((String)((Object)this.delegate.getOperationMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(this.getComponentId(componentModel), componentAst.getLocation().toString(), this.resolveEffectiveTimestamp(componentModel), this.toolingArtifactProperties), () -> {
            MetadataResult result = (MetadataResult)resolver.call();
            List<Object> failures = Collections.emptyList();
            if (!result.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(result.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(result.isSuccess()), (Serializable)((Object)this.serialize(result)), failures);
        })));
    }

    @Override
    public MetadataResult<SourceModel> getSourceMetadata(CompatibleComponentAst componentAst, Callable<MetadataResult<SourceModel>> resolver) {
        ComponentModel componentModel = this.getComponentModel(componentAst);
        return (MetadataResult)this.deserialize((String)((Object)this.delegate.getSourceMetadata((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(this.getComponentId(componentModel), componentAst.getLocation().toString(), this.resolveEffectiveTimestamp(componentModel), this.toolingArtifactProperties), () -> {
            MetadataResult result = (MetadataResult)resolver.call();
            List<Object> failures = Collections.emptyList();
            if (!result.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(result.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(result.isSuccess()), (Serializable)((Object)this.serialize(result)), failures);
        })));
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(CompatibleComponentAst componentAst, Callable<MetadataResult<MetadataKeysContainer>> resolver) {
        ComponentModel componentModel = this.getComponentModel(componentAst);
        return (MetadataResult)this.deserialize((String)((Object)this.delegate.getMetadataKeys((MetadataCache.MetadataCacheKeyInfo)new ImmutableMetadataCacheKeyInfo(this.getComponentId(componentModel), componentAst.getLocation().toString(), this.resolveEffectiveTimestamp(componentModel), this.toolingArtifactProperties), () -> {
            MetadataResult result = (MetadataResult)resolver.call();
            List<Object> failures = Collections.emptyList();
            if (!result.isSuccess()) {
                failures = MetadataPartsFactory.toMetadataFailuresDTO(result.getFailures());
            }
            return new ImmutableMetadataResult(Boolean.valueOf(result.isSuccess()), (Serializable)((Object)this.serialize(result)), failures);
        })));
    }

    @Override
    public void dispose(CompatibleComponentAst componentAst) {
    }

    @Override
    public void invalidateMetadataKeysFor(CompatibleComponentAst componentAst) {
    }

    @NotNull
    private ComponentModel getComponentModel(CompatibleComponentAst componentAst) {
        return (ComponentModel)componentAst.getModel(ComponentModel.class).orElseThrow(() -> new IllegalArgumentException(String.format("A componentModel should be associated for %s", componentAst.getLocation())));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String serialize(Object object) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Output output = new Output((OutputStream)byteArrayOutputStream);){
                this.kryoSerializer.writeClassAndObject(output, object);
            }
            String string = Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new ToolingException("Error while creating object from serialization", (Throwable)e);
        }
    }

    private <T> T deserialize(String content) {
        try (Input input = new Input((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(content)));){
            Object object = this.kryoSerializer.readClassAndObject(input);
            return (T)object;
        }
    }

    private Optional<Long> resolveTimestamp(ComponentModel componentModel) {
        if (componentModel == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Long.parseLong((String)componentModel.getParameters().get("doc:timestamp")));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private Optional<String> getConfigurationRef(ComponentModel componentModel) {
        return Optional.ofNullable(componentModel.getParameters().get("config-ref"));
    }

    private String getComponentId(ComponentModel componentModel) {
        return IdComponentModelSelector.getComponentId((ComponentModel)componentModel);
    }

    private Long resolveEffectiveTimestamp(ComponentModel componentModel) {
        Long componentTimestamp = this.resolveTimestamp(componentModel).orElse(null);
        Optional relatedConfigurationOptional = this.getConfigurationRef(componentModel).flatMap(arg_0 -> ((ApplicationModel)((ApplicationModel)this.applicationModel.get())).findTopLevelNamedComponent(arg_0));
        if (relatedConfigurationOptional.isPresent()) {
            Long configurationTimestamp = this.resolveTimestamp((ComponentModel)relatedConfigurationOptional.get()).orElse(null);
            return componentTimestamp != null && configurationTimestamp != null ? Long.valueOf(Long.max(componentTimestamp, configurationTimestamp)) : null;
        }
        return componentTimestamp;
    }
}

