/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageFactory;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.CachedExtensionModelService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultExtensionModelService;
import org.mule.tooling.client.internal.DefaultMuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClient;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.ExtensionModelTargetVersionMediator;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.action.DispacheableAction;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.metadata.MetadataCacheStorageMapWrapperFactory;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.service.ServiceRegistry;

public class DefaultToolingRuntimeClientBuilder
implements ToolingRuntimeClient.Builder,
Command {
    private Optional<MuleVersion> targetMuleVersion = Optional.empty();
    private String toolingVersion;
    private Serializer serializer;
    private MavenClient mavenClient;
    private ModuleRepository moduleRepository;
    private ArtifactClassLoader containerClassLoaderFactory;
    private Optional<ExtensionModelServiceCache> extensionModelServiceCache;
    private ApplicationCache applicationCache;
    private DomainCache domainCache;
    private Optional<MetadataCacheFactory> metadataCacheFactoryOptional = Optional.empty();
    private Optional<MetadataCacheStorageMapWrapperFactory> metadataCacheStorageMapWrapperFactory = Optional.empty();
    private DslSyntaxServiceCache dslSyntaxServiceCache;
    private ServiceRegistry serviceRegistry;
    private AgentConfiguration agentConfiguration;
    private File workingDirectory;

    public DefaultToolingRuntimeClientBuilder(String toolingVersion, Serializer serializer, ModuleRepository moduleRepository, ArtifactClassLoader containerClassLoaderFactory, Optional<ExtensionModelServiceCache> extensionModelServiceCache, ApplicationCache applicationCache, DomainCache domainCache, DslSyntaxServiceCache dslSyntaxServiceCache, ServiceRegistry serviceRegistry, File workingDirectory) {
        this.toolingVersion = toolingVersion;
        this.serializer = serializer;
        this.moduleRepository = moduleRepository;
        this.containerClassLoaderFactory = containerClassLoaderFactory;
        this.extensionModelServiceCache = extensionModelServiceCache;
        this.applicationCache = applicationCache;
        this.domainCache = domainCache;
        this.dslSyntaxServiceCache = dslSyntaxServiceCache;
        this.serviceRegistry = serviceRegistry;
        this.workingDirectory = workingDirectory;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenClient = MavenClientProvider.discoverProvider((ClassLoader)DefaultToolingRuntimeClientBuilder.class.getClassLoader()).createMavenClient(mavenConfiguration);
        return this;
    }

    public Feature<Action<String>> withTargetRuntimeVersion() {
        return Feature.enabled(new DispacheableAction<String>(targetRuntimeVersion -> {
            Objects.requireNonNull(targetRuntimeVersion, "targetRuntimeVersion cannot be null");
            this.targetMuleVersion = Optional.of(new MuleVersion(targetRuntimeVersion));
        }, String.class, this.serializer));
    }

    public ToolingRuntimeClient.Builder withMetadataCacheFactory(MetadataCacheFactory metadataCacheFactory) {
        this.metadataCacheFactoryOptional = Optional.ofNullable(metadataCacheFactory);
        return this;
    }

    public Feature<Action<MetadataCacheStorageFactory>> withMetadataCacheStorageFactory() {
        return Feature.enabled(f -> {
            throw new UnsupportedOperationException();
        });
    }

    public ToolingRuntimeClient.Builder withMetadataCacheStorageMapWrapperFactory(MetadataCacheStorageMapWrapperFactory metadataCacheStorageMapWrapperFactory) {
        this.metadataCacheStorageMapWrapperFactory = Optional.ofNullable(metadataCacheStorageMapWrapperFactory);
        return this;
    }

    public ToolingRuntimeClient build() {
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(this.toolingVersion, this.targetMuleVersion, this.mavenClient, this.moduleRepository, this.containerClassLoaderFactory, this.workingDirectory);
        DefaultExtensionModelService extensionModelService = new DefaultExtensionModelService(muleArtifactResourcesRegistry);
        MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider = new DefaultMuleRuntimeExtensionModelProvider(this.mavenClient, extensionModelService);
        if (this.extensionModelServiceCache.isPresent()) {
            muleRuntimeExtensionModelProvider = new CachedExtensionModelService(this.mavenClient, this.extensionModelServiceCache.get(), extensionModelService);
        }
        if (muleArtifactResourcesRegistry.getTargetMuleVersion().isPresent()) {
            muleRuntimeExtensionModelProvider = new ExtensionModelTargetVersionMediator(muleArtifactResourcesRegistry.getTargetMuleVersion().get(), muleRuntimeExtensionModelProvider);
        }
        return new DefaultToolingRuntimeClient(this.mavenClient, this.serializer, Optional.ofNullable(this.agentConfiguration), muleRuntimeExtensionModelProvider, muleArtifactResourcesRegistry, this.applicationCache, this.domainCache, this.metadataCacheFactoryOptional, this.metadataCacheStorageMapWrapperFactory, this.dslSyntaxServiceCache, this.serviceRegistry);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "withRemoteAgentConfiguration": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(AgentConfiguration.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.withRemoteAgentConfiguration((AgentConfiguration)this.serializer.deserialize(arguments[0]));
                return this;
            }
            case "withMavenConfiguration": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MavenConfiguration.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                this.withMavenConfiguration((MavenConfiguration)this.serializer.deserialize(arguments[0]));
                return this;
            }
            case "withTargetRuntimeVersion": {
                Preconditions.checkState((arguments.length == 0 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                return this.withTargetRuntimeVersion();
            }
            case "build": {
                return this.build();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

