/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.datasense.api.metadataprovider.CompatibleComponentAst;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.tooling.client.api.component.location.Location;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.action.DispacheableAction;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.serialization.Serializer;

public class ToolingMetadataServiceAdapter
implements MetadataService,
Command {
    private LazyValue<ApplicationModel> applicationModel;
    private LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<CompatibleComponentAst>> componentLocator;
    private LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentConfiguration>> configurationLocator;
    private LazyValue<MetadataCacheIdGenerator<ComponentConfiguration>> metadataCacheIdGenerator;
    private MetadataProvider metadataProvider;
    private LazyValue<MetadataCache> metadataCache;
    private Serializer serializer;

    public ToolingMetadataServiceAdapter(LazyValue<ApplicationModel> applicationModel, MetadataProvider metadataProvider, LazyValue<MetadataCache> metadataCache, Serializer serializer, LazyValue<DslResolvingContext> dslResolvingContext, LazyValue<DslElementModelFactory> dslElementModelFactory, LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentModel>> componentLocator) {
        com.google.common.base.Preconditions.checkNotNull(applicationModel, (Object)"applicationModel cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull(dslResolvingContext, (Object)"dslResolvingContext cannot be null");
        com.google.common.base.Preconditions.checkNotNull(dslElementModelFactory, (Object)"dslElementModelFactory cannot be null");
        com.google.common.base.Preconditions.checkNotNull(componentLocator, (Object)"configurationLocator cannot be null");
        this.applicationModel = applicationModel;
        this.metadataProvider = metadataProvider;
        this.metadataCache = metadataCache;
        this.serializer = serializer;
        this.componentLocator = new LazyValue(() -> location -> ((MetadataCacheIdGeneratorFactory.ComponentLocator)componentLocator.get()).get(location).flatMap(cm -> ((DslElementModelFactory)dslElementModelFactory.get()).create(cm.getConfiguration()).map(dslm -> new CompatibleComponentAst(cm, location, dslm.getModel()))));
        this.configurationLocator = new LazyValue(() -> location -> ((MetadataCacheIdGeneratorFactory.ComponentLocator)componentLocator.get()).get(location).map(ComponentModel::getConfiguration));
        this.metadataCacheIdGenerator = new LazyValue(() -> new ModelBasedMetadataCacheIdGeneratorFactory().create((DslResolvingContext)dslResolvingContext.get(), (MetadataCacheIdGeneratorFactory.ComponentLocator)this.configurationLocator.get()));
    }

    public org.mule.tooling.client.api.metadata.MetadataResult<org.mule.tooling.client.api.metadata.MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException {
        Optional componentModel = ((MetadataCacheIdGeneratorFactory.ComponentLocator)this.componentLocator.get()).get(org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)metadataKeysRequest.getLocation().toString()).build());
        MetadataResult metadataKeys = !componentModel.isPresent() ? MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(String.format("No object found at location %s", metadataKeysRequest.getLocation().toString())).withFailureCode(FailureCode.COMPONENT_NOT_FOUND).onKeys()}) : ((MetadataCache)this.metadataCache.get()).getMetadataKeys((CompatibleComponentAst)componentModel.get(), () -> this.metadataProvider.getMetadataKeys(metadataKeysRequest));
        return MetadataPartsFactory.toMetadataResultDTO(metadataKeys, () -> MetadataPartsFactory.toMetadataKeysContainerDTO((MetadataKeysContainer)metadataKeys.get()));
    }

    private void invalidateRuntimeCacheFor(org.mule.runtime.api.component.location.Location componentLocation) {
        ((MetadataCacheIdGeneratorFactory.ComponentLocator)this.configurationLocator.get()).get(componentLocation).ifPresent(componentConfiguration -> ((MetadataCacheIdGenerator)this.metadataCacheIdGenerator.get()).getIdForGlobalMetadata(componentConfiguration).ifPresent(metadataCacheId -> this.metadataProvider.disposeMetadataCache(metadataCacheId.getValue())));
    }

    public Feature<Action<Location>> disposeMetadataCache() {
        return Feature.enabled(new DispacheableAction<Location>(location -> {
            org.mule.runtime.api.component.location.Location componentLocation = org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location.toString()).build();
            ((MetadataCacheIdGeneratorFactory.ComponentLocator)this.componentLocator.get()).get(componentLocation).ifPresent(ccast -> {
                this.invalidateRuntimeCacheFor(componentLocation);
                ((MetadataCache)this.metadataCache.get()).dispose((CompatibleComponentAst)ccast);
            });
        }, Location.class, this.serializer));
    }

    public Feature<Action<Location>> invalidateMetadataCacheKeys() {
        return Feature.enabled(new DispacheableAction<Location>(location -> {
            org.mule.runtime.api.component.location.Location componentLocation = org.mule.runtime.api.component.location.Location.builderFromStringRepresentation((String)location.toString()).build();
            ((MetadataCacheIdGeneratorFactory.ComponentLocator)this.componentLocator.get()).get(componentLocation).ifPresent(ccast -> {
                this.invalidateRuntimeCacheFor(componentLocation);
                ((MetadataCache)this.metadataCache.get()).invalidateMetadataKeysFor((CompatibleComponentAst)ccast);
            });
        }, Location.class, this.serializer));
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getMetadataKeys": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(MetadataKeysRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize(this.getMetadataKeys((MetadataKeysRequest)this.serializer.deserialize(arguments[0])));
            }
            case "disposeMetadataCache": {
                return this.disposeMetadataCache();
            }
            case "invalidateMetadataCacheKeys": {
                return this.invalidateMetadataCacheKeys();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

