/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static java.util.stream.Collectors.toList;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.tooling.client.api.component.ComponentType;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;

import java.util.List;
import java.util.Optional;

public class ComponentLocationFactory {

  public static org.mule.tooling.client.api.component.location.ComponentLocation toComponentLocationDTO(ComponentLocation componentLocation) {
    return new org.mule.tooling.client.api.component.location.ComponentLocation(
                                                                                componentLocation.getLocation(),
                                                                                toTypedComponentIdentifierDTO(componentLocation
                                                                                    .getComponentIdentifier()),
                                                                                toLocationPartsDTO(componentLocation
                                                                                    .getParts()),
                                                                                toSourceCodeLocationDTO(componentLocation));
  }

  public static List<org.mule.tooling.client.api.component.location.LocationPart> toLocationPartsDTO(List<LocationPart> locationParts) {
    return locationParts.stream().map(locationPart -> toLocationPartDTO(locationPart)).collect(toList());
  }

  public static org.mule.tooling.client.api.component.location.LocationPart toLocationPartDTO(LocationPart locationPart) {
    Optional<SourceCodeLocation> sourceCodeLocation = toSourceCodeLocationDTO(locationPart);
    return new org.mule.tooling.client.api.component.location.LocationPart(locationPart.getPartPath(),
                                                                           toTypedComponentIdentifierDTO(locationPart
                                                                               .getPartIdentifier().orElse(null)),
                                                                           sourceCodeLocation);
  }

  public static Optional<SourceCodeLocation> toSourceCodeLocationDTO(LocationPart locationPart) {
    Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
    if (locationPart.getFileName().isPresent() && locationPart.getLineInFile().isPresent()
        && locationPart.getStartColumn().isPresent()) {
      sourceCodeLocation =
          Optional.of(new SourceCodeLocation(locationPart.getFileName().get(), locationPart.getLineInFile().get(),
                                             locationPart.getStartColumn().get()));
    }
    return sourceCodeLocation;
  }

  public static Optional<SourceCodeLocation> toSourceCodeLocationDTO(ComponentLocation componentLocation) {
    Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
    if (componentLocation.getFileName().isPresent() && componentLocation.getLineInFile().isPresent()
        && componentLocation.getStartColumn().isPresent()) {
      sourceCodeLocation =
          Optional.of(new SourceCodeLocation(componentLocation.getFileName().get(), componentLocation.getLineInFile().get(),
                                             componentLocation.getStartColumn().get()));
    }
    return sourceCodeLocation;
  }

  public static org.mule.tooling.client.api.component.TypedComponentIdentifier toTypedComponentIdentifierDTO(TypedComponentIdentifier typedComponentIdentifier) {
    if (typedComponentIdentifier == null) {
      return null;
    }
    ComponentIdentifier componentIdentifier = typedComponentIdentifier.getIdentifier();
    TypedComponentIdentifier.ComponentType componentType = typedComponentIdentifier.getType();
    org.mule.tooling.client.api.component.ComponentIdentifier componentIdentifierDTO =
        new org.mule.tooling.client.api.component.ComponentIdentifier(componentIdentifier.getName(),
                                                                      componentIdentifier.getNamespace(),
                                                                      componentIdentifier.getNamespaceUri());
    ComponentType componentTypeDTO = toComponentTypeToDTO(componentType);
    return new org.mule.tooling.client.api.component.TypedComponentIdentifier(componentIdentifierDTO, componentTypeDTO);
  }

  public static ComponentType toComponentTypeToDTO(TypedComponentIdentifier.ComponentType componentType) {
    if (componentType == TypedComponentIdentifier.ComponentType.FLOW) {
      return ComponentType.flowComponentType(componentType.name());
    }
    if (componentType == TypedComponentIdentifier.ComponentType.ERROR_HANDLER) {
      return ComponentType.errorHandlingComponentType(componentType.name());
    }
    if (componentType == TypedComponentIdentifier.ComponentType.ON_ERROR) {
      return ComponentType.onErrorComponentType(componentType.name());
    }
    if (componentType == TypedComponentIdentifier.ComponentType.OPERATION) {
      return ComponentType.operationComponentType(componentType.name());
    }
    if (componentType == TypedComponentIdentifier.ComponentType.ROUTER) {
      return ComponentType.routerComponentType(componentType.name());
    }
    if (componentType == TypedComponentIdentifier.ComponentType.SOURCE) {
      return ComponentType.sourceComponentType(componentType.name());
    }

    return new ComponentType(componentType.name());
  }

}
