/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;

import java.util.Optional;

/**
 * Responsible for handling Application resources and life cycle.
 *
 * @since 4.0
 */
//TODO unify invokers to internally do the adapter!
public interface Application extends Artifact, RemoteApplicationInvoker {

  /**
   * @return the domain linked for this application.
   */
  Optional<Domain> getDomain();

  /**
   * @return {@link ApplicationDescriptor} for this artifact artifact.
   */
  ApplicationDescriptor getDescriptor();

  /**
   * @return {@code true} if whenever this application is disposed the domain associated to it should be disposed.
   */
  boolean shouldDisposeDomain();

}
