/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.cache;

import org.mule.tooling.client.internal.values.ValueProviderCache;

/**
 * Unchecked exception to wrap any other {@link Exception} thrown by the callable received by the {@link ValueProviderCache}
 */
public class CacheWrappedException extends RuntimeException {

  private static final long serialVersionUID = 4122133235270897112L;
  private final Exception wrapped;

  public CacheWrappedException(Exception wrapped) {
    this.wrapped = wrapped;
  }

  public Exception getWrappedException() {
    return this.wrapped;
  }
}
