/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.cache;

import static org.mule.tooling.client.internal.serialization.KryoFactory.defaultKryo;

import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorageSerializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;

public class DefaultCacheStorageSerializer implements MetadataCacheStorageSerializer {

  private KryoPool kryoPool;

  public DefaultCacheStorageSerializer() {
    this.kryoPool = new KryoPool.Builder(() -> defaultKryo()).build();
  }

  @Override
  public void serialize(OutputStream outputStream, Object object) {
    try (Output output = new Output(new BufferedOutputStream(Base64.getEncoder().wrap(outputStream)))) {
      kryoPool.run(kryo -> {
        kryo.writeClassAndObject(output, object);
        return null;
      });
    }
  }

  @Override
  public <T> T deserialize(InputStream serialized) {
    try (Input input = new Input(new BufferedInputStream(Base64.getDecoder().wrap(serialized)))) {
      return (T) kryoPool.run(kryo -> kryo.readClassAndObject(input));
    }
  }
}
