/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.datasense;

import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;

/**
 * Utility methods for {@link ArtifactAst}.
 *
 * @since 4.1
 */
public final class ApplicationModelUtils {

  private ApplicationModelUtils() {}

  public static Optional<ComponentAst> findComponentWithLocation(ArtifactAst applicationModel,
                                                                 ComponentLocation componentLocation) {
    return applicationModel.recursiveStream().filter(componentModel -> componentModel.getLocation() != null
        && componentModel.getLocation().equals(componentLocation)).findFirst();
  }

}
