/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.AgentTrackingNotificationResponse;
import org.mule.tooling.client.api.configuration.agent.proxy.ProxyConfig;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.DeploymentException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;

import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractRuntimeToolingServiceDecorator implements RuntimeToolingService {

  private final RuntimeToolingService delegate;

  public AbstractRuntimeToolingServiceDecorator(RuntimeToolingService delegate) {
    this.delegate = delegate;
  }

  protected RuntimeToolingService getDelegate() {
    return delegate;
  }

  @Override
  public void setToolingApiUrl(URL url, long defaultConnectTimeout, long defaultReadTimeout,
                               Optional<SslConfiguration> sslConfiguration, Optional<ProxyConfig> proxyConfig,
                               String authorizationToken) {
    delegate.setToolingApiUrl(url, defaultConnectTimeout, defaultReadTimeout, sslConfiguration, proxyConfig, authorizationToken);
  }

  @Override
  public void setMuleVersion(String muleVersion) {
    delegate.setMuleVersion(muleVersion);
  }

  @Override
  public boolean isOperational() {
    return delegate.isOperational();
  }

  @Override
  public String deployApplication(String id, File appLocation, String domainName, Map<String, String> deploymentProperties)
      throws DeploymentException, ServiceUnavailableException {
    return delegate.deployApplication(id, appLocation, domainName, deploymentProperties);
  }

  @Override
  public String deployApplication(String id, File appLocation, Map<String, String> deploymentProperties)
      throws DeploymentException, ServiceUnavailableException {
    return delegate.deployApplication(id, appLocation, deploymentProperties);
  }

  @Override
  public String deployDomain(String id, File domainLocation, Map<String, String> deploymentProperties)
      throws DeploymentException, ServiceUnavailableException {
    return delegate.deployDomain(id, domainLocation, deploymentProperties);
  }

  @Override
  public String deployApplication(String id, InputStream inputStream, Map<String, String> deploymentProperties)
      throws DeploymentException, ServiceUnavailableException {
    return delegate.deployApplication(id, inputStream, deploymentProperties);
  }

  @Override
  public String deployApplication(String id, InputStream inputStream, String domainName, Map<String, String> deploymentProperties)
      throws DeploymentException, ServiceUnavailableException {
    return delegate.deployApplication(id, inputStream, domainName, deploymentProperties);
  }

  @Override
  public String deployDomain(String id, InputStream inputStream, Map<String, String> deploymentProperties)
      throws DeploymentException, ServiceUnavailableException {
    return delegate.deployDomain(id, inputStream, deploymentProperties);
  }

  @Override
  public void disposeApplication(String applicationId) throws ServiceUnavailableException {
    delegate.disposeApplication(applicationId);
  }

  @Override
  public void disposeDomain(String domainId) throws ServiceUnavailableException {
    delegate.disposeDomain(domainId);
  }

  @Override
  public ConnectionValidationResult testConnectionApplication(String applicationId, String componentId, long readTimeout)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
    return delegate.testConnectionApplication(applicationId, componentId, readTimeout);
  }

  @Override
  public ConnectionValidationResult testConnectionDomain(String domainId, String componentId, long readTimeout)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
    return delegate.testConnectionDomain(domainId, componentId, readTimeout);
  }

  @Override
  public ConnectionValidationResult testConnection(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration,
                                                   String componentId, long readTimeout)
      throws UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException,
      ServiceUnavailableException {
    return delegate.testConnection(dependencies, artifactDeclaration, componentId, readTimeout);
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeysApplication(String applicationId, String componentLocation,
                                                                          long readTimeout)
      throws ServiceUnavailableException {
    return delegate.getMetadataKeysApplication(applicationId, componentLocation, readTimeout);
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeysDomain(String domainId, String componentLocation, long readTimeout)
      throws ServiceUnavailableException {
    return delegate.getMetadataKeysDomain(domainId, componentLocation, readTimeout);
  }

  @Override
  public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId,
                                                                                          String componentLocation,
                                                                                          long readTimeout)
      throws ServiceUnavailableException {
    return delegate.getOperationMetadata(applicationId, componentLocation, readTimeout);
  }

  @Override
  public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId,
                                                                                    String componentLocation, long readTimeout)
      throws ServiceUnavailableException {
    return delegate.getSourceMetadata(applicationId, componentLocation, readTimeout);
  }

  @Override
  public void disposeApplicationMetadataCache(String applicationId, String hashKey) {
    delegate.disposeApplicationMetadataCache(applicationId, hashKey);
  }

  @Override
  public void disposeDomainMetadataCache(String domainId, String hashKey) {
    delegate.disposeDomainMetadataCache(domainId, hashKey);
  }

  @Override
  public void enableMessageHistory(String applicationName) throws NoSuchApplicationException {
    delegate.enableMessageHistory(applicationName);
  }

  @Override
  public void disableMessageHistory(String applicationName) {
    delegate.disableMessageHistory(applicationName);
  }

  @Override
  public List<AgentTrackingNotificationResponse> consumeMessageHistoryNotifications(String applicationName, int chunkSize) {
    return delegate.consumeMessageHistoryNotifications(applicationName, chunkSize);
  }

  @Override
  public PreviewResponse runDataWeaveApplication(String applicationId, PreviewRequest request) {
    return delegate.runDataWeaveApplication(applicationId, request);
  }

  @Override
  public PreviewResponse runDataWeaveDomain(String applicationId, PreviewRequest request) {
    return delegate.runDataWeaveDomain(applicationId, request);
  }

  @Override
  public ValueResult getValuesApplication(String applicationId, String location, String providerName) {
    return delegate.getValuesApplication(applicationId, location, providerName);
  }

  @Override
  public ValueResult getValuesDomain(String domainId, String location, String providerName) {
    return delegate.getValuesDomain(domainId, location, providerName);
  }
}
