/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.tooling.client.api.exception.ToolingException;

import java.util.concurrent.Callable;

/**
 * A {@link MetadataCache} that never caches anything.
 */
public class NoOpToolingMetadataCache implements MetadataCache {

  @Override
  public MetadataResult<OperationModel> getOperationMetadata(ComponentAst componentAst,
                                                             Callable<MetadataResult<OperationModel>> resolver) {
    return executeHandling(resolver);
  }

  @Override
  public MetadataResult<SourceModel> getSourceMetadata(ComponentAst componentAst,
                                                       Callable<MetadataResult<SourceModel>> resolver) {
    return executeHandling(resolver);
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentAst componentAst,
                                                               Callable<MetadataResult<MetadataKeysContainer>> resolver) {
    return executeHandling(resolver);
  }

  @Override
  public void dispose(ComponentAst componentAst) {
    //do nothing
  }

  @Override
  public void invalidateMetadataKeysFor(ComponentAst componentAst) {
    //do nothing
  }

  private <T> MetadataResult<T> executeHandling(Callable<MetadataResult<T>> callable) {
    try {
      return callable.call();
    } catch (Exception e) {
      throw new ToolingException(e);
    }
  }
}
