/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.values;


import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.List;
import java.util.concurrent.Callable;

/**
 * Internal interface that defines a cache for storing {@link org.mule.runtime.extension.api.values.ValueProvider}s
 * results
 *
 * @since 4.3.0
 */
public interface ValueProviderCache {

  /**
   * Gets the posible values for the given parameter belonging to the  {@link ComponentAst}, if not present the
   * {@link Callable} should be called and result stored in order to resolve the values.
   *
   * @param componentAst parameter container component
   * @param parameterName name of the parameter to resolves values from
   * @param callable resolution logic if values not present
   * @return {@link ValueResult} with the requested information
   */
  ValueResult getValues(ComponentAst componentAst, String parameterName, Callable<ValueResult> callable);

  /**
   * Dispose the entry that is related to the received {@link ComponentAst} and all the given parameterNames.
   * If no parameterName is received, then all values related to this {@link ComponentAst} will be disposed
   *
   * @param componentAst the element to hash in order to know what to remove
   * @param parameterNames the list of parameters from where to remove the value providers. If empty, all entries from
   *                       all value providers from this component will be deleted.
   */
  void dispose(ComponentAst componentAst, List<String> parameterNames);

}
