/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.codehaus.plexus.util.ExceptionUtils;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.feature.Action;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.value.ResolvingFailure;
import org.mule.tooling.client.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderDisposeRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.action.DispacheableAction;
import org.mule.tooling.client.internal.cache.CacheWrappedException;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.values.ValueProviderCache;

public abstract class AbstractValueProviderService
implements ValueProviderService,
Command {
    private static final String DEPLOYMENT = "DEPLOYMENT";
    private LazyValue<ValueProviderCache> valueProviderCache;
    private LazyValue<? extends ComponentLocator<ComponentAst>> locator;
    private Serializer serializer;

    protected AbstractValueProviderService(Serializer serializer, LazyValue<ValueProviderCache> valueProviderCache, LazyValue<? extends ComponentLocator<ComponentAst>> locator) {
        Objects.requireNonNull(serializer, "serializer cannot be null");
        Objects.requireNonNull(valueProviderCache, "value providers cache cannot be null");
        Objects.requireNonNull(locator, "component locator should not be null");
        this.serializer = serializer;
        this.valueProviderCache = valueProviderCache;
        this.locator = locator;
    }

    public ValueResult getValues(ValueProviderRequest valueProviderRequest) {
        try {
            try {
                return AbstractValueProviderService.toValueResultDTO(((ComponentLocator)this.locator.get()).get(Location.builderFromStringRepresentation((String)valueProviderRequest.getLocation()).build()).map(componentAst -> ((ValueProviderCache)this.valueProviderCache.get()).getValues((ComponentAst)componentAst, valueProviderRequest.getProviderName(), () -> this.doGetValue(valueProviderRequest))).orElse(org.mule.runtime.api.value.ValueResult.resultFrom((org.mule.runtime.api.value.ResolvingFailure)ResolvingFailure.Builder.newFailure().withMessage("Could not find component with location: " + valueProviderRequest.getLocation() + " for resolving values").withFailureCode("INVALID_LOCATION").build())));
            }
            catch (CacheWrappedException e) {
                throw e.getWrappedException();
            }
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            return AbstractValueProviderService.toFailureValueResultDTO(e);
        }
    }

    public Feature<Action<ValueProviderDisposeRequest>> disposeCachedValues() {
        return Feature.enabled(new DispacheableAction<ValueProviderDisposeRequest>(request -> ((ComponentLocator)this.locator.get()).get(Location.builderFromStringRepresentation((String)request.getLocation().toString()).build()).ifPresent(componentAst -> ((ValueProviderCache)this.valueProviderCache.get()).dispose((ComponentAst)componentAst, request.getParameterNames())), ValueProviderDisposeRequest.class, this.serializer));
    }

    protected abstract org.mule.runtime.api.value.ValueResult doGetValue(ValueProviderRequest var1);

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getValues": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(ValueProviderRequest.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                ValueProviderRequest valueProviderRequest = (ValueProviderRequest)this.serializer.deserialize(arguments[0]);
                return this.serializer.serialize((Object)this.getValues(valueProviderRequest));
            }
            case "disposeCachedValues": {
                return this.disposeCachedValues();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    private static ValueResult toValueResultDTO(org.mule.runtime.api.value.ValueResult valueResult) {
        HashSet<org.mule.tooling.client.api.value.Value> values = new HashSet<org.mule.tooling.client.api.value.Value>();
        for (Value value : valueResult.getValues()) {
            values.add(AbstractValueProviderService.toValueDTO(value));
        }
        return new ValueResult(values, AbstractValueProviderService.toResolvingFailureDTO(valueResult.getFailure()));
    }

    private static org.mule.tooling.client.api.value.Value toValueDTO(Value value) {
        HashSet<org.mule.tooling.client.api.value.Value> children = new HashSet<org.mule.tooling.client.api.value.Value>();
        for (Value child : value.getChilds()) {
            children.add(AbstractValueProviderService.toValueDTO(child));
        }
        return new org.mule.tooling.client.api.value.Value(value.getId(), value.getDisplayName(), value.getPartName(), children);
    }

    private static ResolvingFailure toResolvingFailureDTO(Optional<org.mule.runtime.api.value.ResolvingFailure> resolvingFailureOptional) {
        if (!resolvingFailureOptional.isPresent()) {
            return null;
        }
        org.mule.runtime.api.value.ResolvingFailure resolvingFailure = resolvingFailureOptional.get();
        return new ResolvingFailure(resolvingFailure.getMessage(), resolvingFailure.getReason(), resolvingFailure.getFailureCode());
    }

    private static ValueResult toFailureValueResultDTO(Throwable t) {
        String failureCode = "UNKNOWN";
        if (t instanceof CompletionException && t.getCause() instanceof DeploymentException) {
            failureCode = DEPLOYMENT;
        }
        return new ValueResult(Collections.emptySet(), new ResolvingFailure(t.getMessage(), ExceptionUtils.getStackTrace((Throwable)t), failureCode));
    }
}

