/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.resources.ResourceLoader;
import org.mule.tooling.client.api.component.location.ComponentLocationService;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.feature.Feature;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.ApplicationConnectivityTestingService;
import org.mule.tooling.client.internal.ApplicationValueProviderService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultComponentLocationService;
import org.mule.tooling.client.internal.DefaultDataSenseService;
import org.mule.tooling.client.internal.DomainConnectivityTestingService;
import org.mule.tooling.client.internal.DomainValueProviderService;
import org.mule.tooling.client.internal.InternalApplicationMetadataProvider;
import org.mule.tooling.client.internal.InternalDomainMetadataProvider;
import org.mule.tooling.client.internal.ToolingMetadataServiceAdapter;
import org.mule.tooling.client.internal.UnavailableDataSenseService;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.mule.tooling.client.internal.artifact.DefaultResourceLoader;
import org.mule.tooling.client.internal.datasense.DataSenseArtifact;
import org.mule.tooling.client.internal.dataweave.ApplicationRemoteRunner;
import org.mule.tooling.client.internal.dataweave.DefaultDataWeaveService;
import org.mule.tooling.client.internal.dataweave.DomainRemoteRunner;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.service.ServiceRegistry;
import org.mule.tooling.client.internal.values.ValueProviderCache;

public class DefaultToolingArtifact
implements ToolingArtifact,
Command {
    private final String id;
    private final Artifact artifact;
    private final Serializer serializer;
    private final ConnectivityTestingService connectivityTestingService;
    private final MetadataService metadataService;
    private final DataSenseService dataSenseService;
    private final DataWeaveService dataWeaveService;
    private final ValueProviderService valueProviderService;
    private final ComponentLocationService componentLocationService;
    private ToolingArtifact parentToolingArtifact;

    public DefaultToolingArtifact(String id, Application application, ToolingArtifact parentToolingArtifact, Serializer serializer, ServiceRegistry serviceRegistry, LazyValue<MetadataCache> metadataCache, LazyValue<MetadataCache> parentMetadataCache, LazyValue<DslResolvingContext> dslResolvingContext, LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst>> componentLocator, LazyValue<ValueProviderCache> valueProvidersCache) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        Preconditions.checkNotNull((Object)serviceRegistry, (Object)"serviceRegistry cannot be null");
        Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        Preconditions.checkNotNull(dslResolvingContext, (Object)"dslResolvingContext cannot be null");
        Preconditions.checkNotNull(componentLocator, (Object)"component locator cannot be null");
        this.id = id;
        this.artifact = application;
        this.parentToolingArtifact = parentToolingArtifact;
        this.serializer = serializer;
        InternalApplicationMetadataProvider metadataProvider = new InternalApplicationMetadataProvider(application);
        ApplicationRemoteRunner remoteRunner = new ApplicationRemoteRunner(application);
        this.connectivityTestingService = new ApplicationConnectivityTestingService(application, serializer);
        this.metadataService = new ToolingMetadataServiceAdapter((LazyValue<ArtifactAst>)new LazyValue(() -> application.getApplicationModel().getMuleApplicationModel()), metadataProvider, metadataCache, serializer, dslResolvingContext, componentLocator);
        DataSenseArtifact parentDataSenseArtifact = application.getDomain().map(domain -> new DataSenseArtifact((Artifact)domain, parentMetadataCache, new InternalDomainMetadataProvider((RemoteDomainInvoker)domain), domain.getProperties(), serviceRegistry.getExpressionLanguageMetadataService(), serviceRegistry.getApikitMetadataService(), null)).orElse(null);
        DataSenseArtifact dataSenseArtifact = new DataSenseArtifact(application, metadataCache, metadataProvider, application.getProperties(), serviceRegistry.getExpressionLanguageMetadataService(), serviceRegistry.getApikitMetadataService(), parentDataSenseArtifact);
        this.dataSenseService = new DefaultDataSenseService(dataSenseArtifact, serializer);
        this.valueProviderService = new ApplicationValueProviderService(application, serializer, valueProvidersCache, componentLocator);
        this.dataWeaveService = new DefaultDataWeaveService((LazyValue<ClassLoader>)new LazyValue(() -> application.getArtifactClassLoader().getClassLoader()), remoteRunner, serviceRegistry.getExpressionLanguageMetadataService(), new ModulesAnalyzer(serviceRegistry.getExpressionLanguageCapabilitiesService()), serializer);
        this.componentLocationService = new DefaultComponentLocationService((LazyValue<ArtifactAst>)new LazyValue(() -> application.getApplicationModel().getMuleApplicationModel()), serializer);
    }

    public DefaultToolingArtifact(String id, Domain domain, Serializer serializer, ServiceRegistry serviceRegistry, LazyValue<MetadataCache> metadataCache, LazyValue<DslResolvingContext> dslResolvingContext, LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst>> componentLocator, LazyValue<ValueProviderCache> valueProvidersCache) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)domain, (Object)"domain cannot be null");
        Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        Preconditions.checkNotNull((Object)serviceRegistry, (Object)"serviceRegistry cannot be null");
        Preconditions.checkNotNull(metadataCache, (Object)"metadataCache cannot be null");
        Preconditions.checkNotNull(dslResolvingContext, (Object)"dslResolvingContext cannot be null");
        Preconditions.checkNotNull(componentLocator, (Object)"component locator cannot be null");
        Preconditions.checkNotNull(valueProvidersCache, (Object)"value providers cache cannot be null");
        this.id = id;
        this.artifact = domain;
        this.serializer = serializer;
        InternalDomainMetadataProvider metadataProvider = new InternalDomainMetadataProvider(domain);
        DomainRemoteRunner remoteRunner = new DomainRemoteRunner(domain);
        this.connectivityTestingService = new DomainConnectivityTestingService(domain, serializer);
        this.dataSenseService = new UnavailableDataSenseService(ArtifactType.DOMAIN);
        this.metadataService = new ToolingMetadataServiceAdapter((LazyValue<ArtifactAst>)new LazyValue(() -> domain.getApplicationModel().getMuleApplicationModel()), metadataProvider, metadataCache, serializer, dslResolvingContext, componentLocator);
        this.valueProviderService = new DomainValueProviderService(domain, serializer, valueProvidersCache, componentLocator);
        this.dataWeaveService = new DefaultDataWeaveService((LazyValue<ClassLoader>)new LazyValue(() -> domain.getArtifactClassLoader().getClassLoader()), remoteRunner, serviceRegistry.getExpressionLanguageMetadataService(), new ModulesAnalyzer(serviceRegistry.getExpressionLanguageCapabilitiesService()), serializer);
        this.componentLocationService = new DefaultComponentLocationService((LazyValue<ArtifactAst>)new LazyValue(() -> domain.getApplicationModel().getMuleApplicationModel()), serializer);
    }

    public String getId() {
        return this.id;
    }

    public Optional<ToolingArtifact> getParent() {
        return Optional.ofNullable(this.parentToolingArtifact);
    }

    public Map<String, String> getProperties() {
        return this.artifact.getProperties();
    }

    public ConnectivityTestingService connectivityTestingService() {
        return this.connectivityTestingService;
    }

    public MetadataService metadataService() {
        return this.metadataService;
    }

    public DataSenseService dataSenseService() {
        return this.dataSenseService;
    }

    public DataWeaveService dataWeaveService() {
        return this.dataWeaveService;
    }

    public ValueProviderService valueProviderService() {
        return this.valueProviderService;
    }

    public ComponentLocationService componentLocationService() {
        return this.componentLocationService;
    }

    public void dispose() {
        this.artifact.dispose();
    }

    public Feature<ResourceLoader> getResourceLoader() {
        return Feature.enabled((Object)new DefaultResourceLoader(this.artifact, this.serializer));
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "id": {
                return this.serializer.serialize((Object)this.getId());
            }
            case "getParent": {
                return this.getParent();
            }
            case "connectivityTestingService": {
                return this.connectivityTestingService();
            }
            case "metadataService": {
                return this.metadataService();
            }
            case "dataSenseService": {
                return this.dataSenseService();
            }
            case "dataWeaveService": {
                return this.dataWeaveService();
            }
            case "valueProviderService": {
                return this.valueProviderService();
            }
            case "getResourceLoader": {
                return this.getResourceLoader();
            }
            case "dispose": {
                this.dispose();
                return null;
            }
            case "componentLocationService": {
                return this.componentLocationService();
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

