/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.metadata.ComponentBasedValueProviderCacheIdGenerator;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheIdGenerator;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.tooling.internal.DefaultToolingService;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.datasense.MetadataCacheFactory;
import org.mule.tooling.client.api.exception.ToolingArtifactNotFoundException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.icons.ExtensionIconsService;
import org.mule.tooling.client.api.message.history.MessageHistoryService;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.DefaultMessageHistoryService;
import org.mule.tooling.client.internal.DefaultToolingArtifact;
import org.mule.tooling.client.internal.DefaultToolingArtifactContext;
import org.mule.tooling.client.internal.DomainCache;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.ToolingArtifactWrapper;
import org.mule.tooling.client.internal.ToolingExtensionModelAdapter;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.DefaultApplication;
import org.mule.tooling.client.internal.application.DefaultDomain;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;
import org.mule.tooling.client.internal.artifact.DefaultArtifactSerializationService;
import org.mule.tooling.client.internal.cache.CacheStorageMapWrapperFactory;
import org.mule.tooling.client.internal.dsl.DefaultDslSyntaxResolverService;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.icons.DefaultExtensionIconsService;
import org.mule.tooling.client.internal.metadata.DefaultToolingMetadataCache;
import org.mule.tooling.client.internal.metadata.LegacyToolingMetadataCache;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.metadata.NoOpToolingMetadataCache;
import org.mule.tooling.client.internal.metadata.ToolingMetadataCacheIdGenerator;
import org.mule.tooling.client.internal.serialization.Serializer;
import org.mule.tooling.client.internal.service.ServiceRegistry;
import org.mule.tooling.client.internal.values.DefaultValueProviderCache;
import org.mule.tooling.client.internal.values.NoOpValueProviderCache;
import org.mule.tooling.client.internal.values.ValueProviderCache;

public class DefaultToolingRuntimeClient
implements ToolingRuntimeClient,
Command {
    private final DefaultToolingArtifactContext context;
    private final ExtensionModelService extensionModelService;
    private final ArtifactSerializationService artifactSerializationService;
    private final DslSyntaxResolverService dslSyntaxResolverService;
    private final MessageHistoryService messageHistoryService;
    private final ExtensionIconsService extensionIconsService;

    public DefaultToolingRuntimeClient(MavenClient mavenClient, Serializer serializer, Optional<AgentConfiguration> agentConfigurationOptional, MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry, ApplicationCache applicationCache, DomainCache domainCache, Optional<MetadataCacheFactory> metadataCacheFactoryOptional, Optional<CacheStorageMapWrapperFactory> metadataCacheStorageFactoryOptional, Optional<CacheStorageMapWrapperFactory> valueProvidersCacheStorageFactoryOptional, DslSyntaxServiceCache dslSyntaxServiceCache, ServiceRegistry serviceRegistry) {
        com.google.common.base.Preconditions.checkNotNull((Object)mavenClient, (Object)"aetherDependencyResolver cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        com.google.common.base.Preconditions.checkNotNull(agentConfigurationOptional, (Object)"agentConfigurationOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)muleRuntimeExtensionModelProvider, (Object)"muleRuntimeExtensionModelProvider cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)muleArtifactResourcesRegistry, (Object)"muleArtifactResourcesRegistry cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)applicationCache, (Object)"applicationCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)domainCache, (Object)"domainCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCacheFactoryOptional, (Object)"metadataCacheFactoryOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull(metadataCacheStorageFactoryOptional, (Object)"metadataCacheStorageFactoryOptional cannot be null");
        com.google.common.base.Preconditions.checkNotNull(valueProvidersCacheStorageFactoryOptional, (Object)"valueProvidersCacheStorageFactory cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)dslSyntaxServiceCache, (Object)"dslSyntaxServiceCache cannot be null");
        com.google.common.base.Preconditions.checkNotNull((Object)serviceRegistry, (Object)"serviceRegistry cannot be null");
        this.context = new DefaultToolingArtifactContext(muleArtifactResourcesRegistry);
        this.context.setAgentConfiguration(agentConfigurationOptional);
        this.context.setSerializer(serializer);
        this.context.setMavenClient(mavenClient);
        this.context.setMuleRuntimeExtensionModelProvider(muleRuntimeExtensionModelProvider);
        this.context.setApplicationCache(applicationCache);
        this.context.setDomainCache(domainCache);
        this.context.setMetadataCacheFactory(metadataCacheFactoryOptional);
        this.context.setMetadataCacheStorageFactory(metadataCacheStorageFactoryOptional);
        this.context.setValueProvidersCacheStorageFactory(valueProvidersCacheStorageFactoryOptional);
        this.context.setServiceRegistry(serviceRegistry);
        this.extensionModelService = new ToolingExtensionModelAdapter(muleRuntimeExtensionModelProvider, this.context.getSerializer(), muleArtifactResourcesRegistry.getTargetMuleVersion());
        this.artifactSerializationService = new DefaultArtifactSerializationService(muleRuntimeExtensionModelProvider.getRuntimeExtensionModels(), muleRuntimeExtensionModelProvider, mavenClient, this.context.getSerializer());
        this.messageHistoryService = new DefaultMessageHistoryService((LazyValue<RuntimeToolingService>)new LazyValue(() -> this.context.getRuntimeToolingService()), this.context.getSerializer());
        this.extensionIconsService = new DefaultExtensionIconsService(this.context.getMavenClient(), this.context.getSerializer());
        this.dslSyntaxResolverService = new DefaultDslSyntaxResolverService(dslSyntaxServiceCache, mavenClient, muleRuntimeExtensionModelProvider, this.context.getSerializer());
    }

    public ExtensionModelService extensionModelService() {
        return this.extensionModelService;
    }

    public ArtifactSerializationService artifactSerializationService() {
        return this.artifactSerializationService;
    }

    public DslSyntaxResolverService dslSyntaxResolverService() {
        return this.dslSyntaxResolverService;
    }

    public MessageHistoryService messageHistoryService() {
        return this.messageHistoryService;
    }

    public ExtensionIconsService iconsService() {
        return this.extensionIconsService;
    }

    public ToolingArtifact newToolingArtifact(URL artifactUrlContent, Map<String, String> toolingArtifactProperties) {
        String id = UUID.randomUUID().toString();
        ArtifactResources artifactResources = new ArtifactResources(id, artifactUrlContent);
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.DOMAIN)) {
            Domain domain = this.createDomain(id, artifactResources, toolingArtifactProperties);
            ArtifactLazyDslContext domainLazyDslContext = new ArtifactLazyDslContext(id, domain, this.context);
            return this.newToolingArtifact(id, this.context.getDomainCache(), domain, this.context.getSerializer(), this.context.getServiceRegistry(), domainLazyDslContext);
        }
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.APP)) {
            ApplicationDescriptor applicationDescriptor;
            try {
                applicationDescriptor = (ApplicationDescriptor)this.context.getApplicationDescriptorFactory().create(artifactResources.getRootArtifactFile(), Optional.empty());
            }
            catch (ToolingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ToolingException(String.format("Error while creating application from url: %s", artifactUrlContent), (Throwable)e);
            }
            ToolingArtifact domainToolingArtifact = null;
            ArtifactLazyDslContext domainLazyDslContext = null;
            Reference domainReference = new Reference();
            if (applicationDescriptor.getDomainDescriptor().isPresent()) {
                MavenClient mavenClient = this.context.getMavenClient();
                BundleDescriptor domainBundleDescriptor = (BundleDescriptor)applicationDescriptor.getDomainDescriptor().get();
                BundleDependency domainBundleDependency = mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder().setGroupId(domainBundleDescriptor.getGroupId()).setArtifactId(domainBundleDescriptor.getArtifactId()).setVersion(domainBundleDescriptor.getVersion()).setClassifier((String)domainBundleDescriptor.getClassifier().get()).setType(domainBundleDescriptor.getType()).build());
                String domainId = UUID.randomUUID().toString();
                try {
                    domainReference.set((Object)this.createDomain(domainId, new ArtifactResources(domainId, domainBundleDependency.getBundleUri().toURL()), toolingArtifactProperties));
                }
                catch (MalformedURLException e) {
                    throw new ToolingException("Error while getting Mule domainReference artifact url", (Throwable)e);
                }
                domainLazyDslContext = new ArtifactLazyDslContext(domainId, (Artifact)domainReference.get(), this.context);
                domainToolingArtifact = this.newToolingArtifact(domainId, this.context.getDomainCache(), (Domain)domainReference.get(), this.context.getSerializer(), this.context.getServiceRegistry(), domainLazyDslContext);
            }
            try {
                ApplicationCache applicationCache = this.context.getApplicationCache();
                Application application = applicationCache.getApplication(id, () -> new DefaultApplication(id, artifactResources, applicationDescriptor, (Domain)domainReference.get(), this.context, toolingArtifactProperties, domainReference.get() != null));
                ArtifactLazyDslContext applicationLazyDslContext = new ArtifactLazyDslContext(id, application, this.context);
                return this.newToolingArtifact(id, this.context.getApplicationCache(), application, domainToolingArtifact, this.context.getSerializer(), this.context.getServiceRegistry(), domainLazyDslContext, applicationLazyDslContext);
            }
            catch (ToolingException e) {
                this.disposeIfNeeded(domainToolingArtifact);
                throw e;
            }
            catch (Exception e) {
                this.disposeIfNeeded(domainToolingArtifact);
                throw new ToolingException(String.format("Error while creating application from url: %s", artifactUrlContent), (Throwable)e);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid artifact type, only supported '%s' and '%s'", ArtifactType.DOMAIN, ArtifactType.APP));
    }

    public void disposeIfNeeded(ToolingArtifact domainToolingArtifact) {
        if (domainToolingArtifact != null) {
            domainToolingArtifact.dispose();
        }
    }

    private Domain createDomain(String id, ArtifactResources artifactResources, Map<String, String> toolingArtifactProperties) {
        try {
            DomainDescriptor domainDescriptor = (DomainDescriptor)this.context.getDomainDescriptorFactory().create(artifactResources.getRootArtifactFile(), Optional.empty());
            DomainCache domainCache = this.context.getDomainCache();
            return domainCache.getDomain(id, () -> new DefaultDomain(id, artifactResources, domainDescriptor, (ToolingArtifactContext)this.context, toolingArtifactProperties));
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolingException(String.format("Error while creating domain from url: %s", artifactResources.getArtifactUrlContent()), (Throwable)e);
        }
    }

    public ToolingArtifact newToolingArtifact(URL artifactUrlContent, Map<String, String> toolingArtifactProperties, String parentId) {
        ApplicationDescriptor applicationDescriptor;
        Objects.requireNonNull(artifactUrlContent, "artifactUrlContent cannot be null");
        Objects.requireNonNull(toolingArtifactProperties, "toolingArtifactProperties cannot be null");
        Objects.requireNonNull(parentId, "parentId cannot be null");
        Domain domain = this.context.getDomainCache().getDomain(parentId, () -> {
            throw new ToolingArtifactNotFoundException(String.format("ToolingArtifact not found in Domain's cache for id: %s", parentId));
        });
        ArtifactLazyDslContext domainLazyDslContext = new ArtifactLazyDslContext(domain.getId(), domain, this.context);
        domain.setContext(this.context);
        ToolingArtifact domainToolingArtifact = this.newToolingArtifact(domain.getId(), this.context.getDomainCache(), domain, this.context.getSerializer(), this.context.getServiceRegistry(), domainLazyDslContext);
        String id = UUID.randomUUID().toString();
        ArtifactResources artifactResources = new ArtifactResources(id, artifactUrlContent);
        MuleApplicationModel.MuleApplicationModelBuilder applicationArtifactModelBuilder = this.context.getApplicationDescriptorFactory().createArtifactModelBuilder(artifactResources.getRootArtifactFile());
        MuleArtifactLoaderDescriptor classLoaderModelDescriptorLoader = applicationArtifactModelBuilder.getClassLoaderModelDescriptorLoader();
        HashMap<String, DefaultToolingService.DomainMavenReactorResolver> extendedAttributes = new HashMap<String, DefaultToolingService.DomainMavenReactorResolver>(classLoaderModelDescriptorLoader.getAttributes());
        extendedAttributes.put("_classLoaderModelMavenReactorResolver", new DefaultToolingService.DomainMavenReactorResolver(domain.getDescriptor().getArtifactLocation(), domain.getDescriptor().getBundleDescriptor()));
        applicationArtifactModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(classLoaderModelDescriptorLoader.getId(), extendedAttributes));
        try {
            applicationDescriptor = this.context.getApplicationDescriptorFactory().createArtifact(artifactResources.getRootArtifactFile(), Optional.empty(), (MuleApplicationModel)applicationArtifactModelBuilder.build());
        }
        catch (ToolingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolingException(String.format("Error while creating application from url: %s", artifactUrlContent), (Throwable)e);
        }
        this.checkDomain(domain.getDescriptor().getBundleDescriptor(), applicationDescriptor.getDomainDescriptor());
        applicationDescriptor.setDomainName(domain.getArtifactName());
        ApplicationCache applicationCache = this.context.getApplicationCache();
        Application application = applicationCache.getApplication(id, () -> new DefaultApplication(id, artifactResources, applicationDescriptor, domain, this.context, toolingArtifactProperties, true));
        ArtifactLazyDslContext applicationLazyDslContext = new ArtifactLazyDslContext(id, application, this.context);
        return this.newToolingArtifact(id, this.context.getApplicationCache(), application, domainToolingArtifact, this.context.getSerializer(), this.context.getServiceRegistry(), domainLazyDslContext, applicationLazyDslContext);
    }

    private void checkDomain(BundleDescriptor expectedDomainBundleDescriptor, Optional<BundleDescriptor> applicationDeclaredDomainDescriptor) {
        if (!applicationDeclaredDomainDescriptor.isPresent()) {
            throw new ToolingException("Error while creating application", (Throwable)new IllegalStateException(String.format("Application doesn't declared a domain dependency on its pom.xml to: '%s'", expectedDomainBundleDescriptor)));
        }
        BundleDescriptor actualBundleDescriptor = applicationDeclaredDomainDescriptor.get();
        if (!(expectedDomainBundleDescriptor.getGroupId().equals(actualBundleDescriptor.getGroupId()) && expectedDomainBundleDescriptor.getArtifactId().equals(actualBundleDescriptor.getArtifactId()) && expectedDomainBundleDescriptor.getVersion().equals(actualBundleDescriptor.getVersion()))) {
            throw new ToolingException("Error while creating application", (Throwable)new IllegalStateException(String.format("Application declares a different domain dependency on its pom.xml expected: '%s' but was: '%s'", expectedDomainBundleDescriptor, actualBundleDescriptor)));
        }
    }

    public ToolingArtifact fetchToolingArtifact(String id) throws ToolingArtifactNotFoundException {
        Optional<Domain> domainOptional = this.context.getDomainCache().getDomain(id);
        if (domainOptional.isPresent()) {
            Domain domain = domainOptional.get();
            ArtifactLazyDslContext domainLazyDslContext = new ArtifactLazyDslContext(domain.getId(), domain, this.context);
            return this.createDomainToolingArtifact(domainOptional.get(), this.context.getServiceRegistry(), domainLazyDslContext);
        }
        Application application = this.context.getApplicationCache().getApplication(id, () -> {
            throw new ToolingArtifactNotFoundException(String.format("ToolingArtifact not found in cache for id: %s", id));
        });
        ArtifactLazyDslContext applicationLazyDslContext = new ArtifactLazyDslContext(id, application, this.context);
        application.setContext(this.context);
        if (application.getDomain().isPresent()) {
            Domain domain = application.getDomain().get();
            ArtifactLazyDslContext domainLazyDslContext = new ArtifactLazyDslContext(domain.getId(), domain, this.context);
            ToolingArtifact domainToolingArtifact = this.createDomainToolingArtifact(domain, this.context.getServiceRegistry(), domainLazyDslContext);
            return this.newToolingArtifact(id, this.context.getApplicationCache(), application, domainToolingArtifact, this.context.getSerializer(), this.context.getServiceRegistry(), domainLazyDslContext, applicationLazyDslContext);
        }
        return this.newToolingArtifact(id, this.context.getApplicationCache(), application, null, this.context.getSerializer(), this.context.getServiceRegistry(), null, applicationLazyDslContext);
    }

    private ToolingArtifact createDomainToolingArtifact(Domain domain, ServiceRegistry serviceRegistry, ArtifactLazyDslContext domainLazyDslContext) {
        domain.setContext(this.context);
        return this.newToolingArtifact(domain.getId(), this.context.getDomainCache(), domain, this.context.getSerializer(), serviceRegistry, domainLazyDslContext);
    }

    private ToolingArtifact newToolingArtifact(final String id, final ApplicationCache applicationCache, final Application application, final ToolingArtifact parentToolingArtifact, Serializer serializer, ServiceRegistry serviceRegistry, ArtifactLazyDslContext parentLazyDslContext, ArtifactLazyDslContext artifactLazyDslContext) {
        return new ToolingArtifactWrapper(new DefaultToolingArtifact(id, application, parentToolingArtifact, serializer, serviceRegistry, artifactLazyDslContext.getArtifactMetadataCache(), parentLazyDslContext != null ? parentLazyDslContext.getArtifactMetadataCache() : null, artifactLazyDslContext.getDslResolvingContext(), artifactLazyDslContext.getComponentLocator(), artifactLazyDslContext.getArtifactValueProvidersCache()){

            @Override
            public void dispose() {
                applicationCache.invalidate(id);
                if (application.shouldDisposeDomain() && parentToolingArtifact != null) {
                    parentToolingArtifact.dispose();
                }
            }
        });
    }

    private ToolingArtifact newToolingArtifact(final String id, final DomainCache domainCache, Domain domain, Serializer serializer, ServiceRegistry serviceRegistry, ArtifactLazyDslContext artifactLazyDslContext) {
        return new ToolingArtifactWrapper(new DefaultToolingArtifact(id, domain, serializer, serviceRegistry, artifactLazyDslContext.getArtifactMetadataCache(), artifactLazyDslContext.getDslResolvingContext(), artifactLazyDslContext.getComponentLocator(), artifactLazyDslContext.getArtifactValueProvidersCache()){

            @Override
            public void dispose() {
                domainCache.invalidate(id);
            }
        });
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        Serializer serializer = this.context.getSerializer();
        switch (methodName) {
            case "messageHistoryService": {
                return this.messageHistoryService();
            }
            case "extensionModelService": {
                return this.extensionModelService();
            }
            case "artifactSerializationService": {
                return this.artifactSerializationService();
            }
            case "dslSyntaxResolverService": {
                return this.dslSyntaxResolverService();
            }
            case "iconsService": {
                return this.iconsService();
            }
            case "newToolingArtifact": {
                if (arguments.length == 3) {
                    Preconditions.checkState((arguments.length == 3 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 3 && classes[0].equals(URL.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 3 && classes[1].equals(Map.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 3 && classes[2].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    return this.newToolingArtifact((URL)serializer.deserialize(arguments[0]), (Map)serializer.deserialize(arguments[1]), (String)serializer.deserialize(arguments[2]));
                }
                if (arguments.length == 2) {
                    Preconditions.checkState((arguments.length == 2 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 2 && classes[0].equals(URL.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    Preconditions.checkState((classes.length == 2 && classes[1].equals(Map.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                    return this.newToolingArtifact((URL)serializer.deserialize(arguments[0]), (Map)serializer.deserialize(arguments[1]));
                }
                Preconditions.checkState((arguments.length == 2 || arguments.length == 3 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
            }
            case "fetchToolingArtifact": {
                Preconditions.checkState((arguments.length == 1 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                Preconditions.checkState((classes.length == 1 && classes[0].equals(String.class.getName()) ? 1 : 0) != 0, (String)String.format("Wrong type of arguments when invoking method created on %s", this.getClass().getName()));
                return this.fetchToolingArtifact((String)serializer.deserialize(arguments[0]));
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }

    private static class ArtifactLazyDslContext {
        private final LazyValue<MetadataCache> artifactMetadataCache;
        private final LazyValue<ValueProviderCache> artifactValueProviderCache;
        private final LazyValue<ToolingMetadataCacheIdGenerator> toolingMetadataCacheIdGenerator;
        private final LazyValue<ValueProviderCacheIdGenerator<ComponentAst>> toolingValueProviderCacheIdGenerator;
        private final LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst>> componentLocator;
        private final LazyValue<DslResolvingContext> dslResolvingContext = new LazyValue(() -> {
            HashSet<ExtensionModel> extensionModels = new HashSet<ExtensionModel>(artifact.getExtensionModels());
            return DslResolvingContext.getDefault(extensionModels);
        });

        ArtifactLazyDslContext(String id, Artifact artifact, DefaultToolingArtifactContext toolingContext) {
            this.componentLocator = new LazyValue(() -> {
                Optional<ArtifactAst> parentOptional = artifact.getApplicationModel().getParent().map(ToolingApplicationModel::getMuleApplicationModel);
                return new Locator(artifact.getApplicationModel().getMuleApplicationModel(), parentOptional);
            });
            this.toolingMetadataCacheIdGenerator = new LazyValue(() -> new ToolingMetadataCacheIdGenerator((DslResolvingContext)this.dslResolvingContext.get(), (MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst>)((MetadataCacheIdGeneratorFactory.ComponentLocator)this.componentLocator.get())));
            this.artifactMetadataCache = new LazyValue(() -> {
                if (toolingContext.getMetadataCacheStorageMapWrapperFactory().isPresent()) {
                    Map metadataCache = toolingContext.getMetadataCacheStorageMapWrapperFactory().get().create(id, artifact.getArtifactUrlContent(), artifact.getProperties());
                    return new DefaultToolingMetadataCache(metadataCache, metadataCache, metadataCache, (ToolingMetadataCacheIdGenerator)this.toolingMetadataCacheIdGenerator.get());
                }
                if (toolingContext.getMetadataCacheFactory().isPresent()) {
                    org.mule.tooling.client.api.datasense.MetadataCache metadataCache = toolingContext.getMetadataCacheFactory().get().createMetadataCache(id, artifact.getArtifactUrlContent(), artifact.getProperties());
                    return new LegacyToolingMetadataCache((LazyValue<ArtifactAst>)new LazyValue(() -> artifact.getApplicationModel().getMuleApplicationModel()), artifact.getProperties(), metadataCache);
                }
                return new NoOpToolingMetadataCache();
            });
            this.toolingValueProviderCacheIdGenerator = new LazyValue(() -> new ComponentBasedValueProviderCacheIdGenerator((DslResolvingContext)this.dslResolvingContext.get(), (ComponentLocator)this.componentLocator.get()));
            this.artifactValueProviderCache = new LazyValue(() -> toolingContext.getValueProvidersCacheStorageMapWrapperFactory().map(sf -> {
                Map valueProvidersStorage = sf.create(id, artifact.getArtifactUrlContent(), artifact.getProperties());
                return new DefaultValueProviderCache(valueProvidersStorage, (ValueProviderCacheIdGenerator<ComponentAst>)((ValueProviderCacheIdGenerator)this.toolingValueProviderCacheIdGenerator.get()));
            }).orElse(new NoOpValueProviderCache()));
        }

        LazyValue<MetadataCache> getArtifactMetadataCache() {
            return this.artifactMetadataCache;
        }

        LazyValue<ValueProviderCache> getArtifactValueProvidersCache() {
            return this.artifactValueProviderCache;
        }

        LazyValue<ToolingMetadataCacheIdGenerator> getToolingMetadataCacheIdGenerator() {
            return this.toolingMetadataCacheIdGenerator;
        }

        LazyValue<DslResolvingContext> getDslResolvingContext() {
            return this.dslResolvingContext;
        }

        LazyValue<MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst>> getComponentLocator() {
            return this.componentLocator;
        }
    }

    private static class Locator
    implements MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst> {
        private final Map<Location, ComponentAst> components = new HashMap<Location, ComponentAst>();

        Locator(ArtifactAst app, Optional<ArtifactAst> parentAppOptional) {
            app.recursiveStream().forEach(this::addComponent);
            parentAppOptional.ifPresent(pam -> pam.recursiveStream().forEach(this::addComponent));
        }

        public Optional<ComponentAst> get(Location location) {
            return Optional.ofNullable(this.components.get(location));
        }

        private Optional<Location> getLocation(ComponentAst component) {
            Optional<ComponentLocation> componentLocation = Optional.ofNullable(component.getLocation());
            return componentLocation.map(cl -> Location.builderFromStringRepresentation((String)cl.getLocation()).build());
        }

        private void addComponent(ComponentAst component) {
            this.getLocation(component).ifPresent(cl -> this.components.put((Location)cl, component));
        }
    }
}

