/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.DefaultApplicationModelFactory;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.AbstractArtifact;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;

public class DefaultApplication
extends AbstractArtifact<ApplicationDescriptor>
implements Application {
    private final Optional<Domain> domain;
    private boolean shouldDisposeDomain = false;
    private final List<ArtifactPluginDescriptor> effectivePlugins;

    public DefaultApplication(String id, ArtifactResources artifactResources, ApplicationDescriptor applicationDescriptor, Domain domain, ToolingArtifactContext context, Map<String, String> properties, boolean shouldDisposeDomain) {
        super(id, artifactResources, applicationDescriptor, context, properties);
        if (shouldDisposeDomain && domain == null) {
            throw new IllegalArgumentException("Application cannot be set to dispose the domain without setting a domain reference");
        }
        this.domain = Optional.ofNullable(domain);
        this.shouldDisposeDomain = shouldDisposeDomain;
        this.effectivePlugins = this.effectivePlugins(context.getPluginDependenciesResolver());
    }

    @Override
    public List<ArtifactPluginDescriptor> getEffectivePlugins() {
        return this.effectivePlugins;
    }

    private List<ArtifactPluginDescriptor> effectivePlugins(PluginDependenciesResolver applicationPluginDescriptorsResolver) {
        if (this.domain.isPresent()) {
            try {
                return applicationPluginDescriptorsResolver.resolve(this.domain.get().getDescriptor().getPlugins(), new LinkedList(this.getDescriptor().getPlugins()), true);
            }
            catch (Exception e) {
                throw new ToolingException("Error while creating application", (Throwable)e);
            }
        }
        return ImmutableList.copyOf((Collection)this.getDescriptor().getPlugins());
    }

    @Override
    public boolean shouldDisposeDomain() {
        return this.shouldDisposeDomain;
    }

    @Override
    public Optional<Domain> getDomain() {
        return this.domain;
    }

    @Override
    public ApplicationDescriptor getDescriptor() {
        return (ApplicationDescriptor)this.artifactDescriptor;
    }

    @Override
    protected List<ArtifactClassLoader> getArtifactPluginClassLoaders() {
        if (!this.domain.isPresent()) {
            return super.getArtifactPluginClassLoaders();
        }
        return ImmutableList.builder().addAll((Iterable)this.domain.get().getArtifactClassLoader().getArtifactPluginClassLoaders()).addAll((Iterable)this.getArtifactClassLoader().getArtifactPluginClassLoaders()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R evaluateWithRemoteApplication(RemoteApplicationInvoker.ApplicationRemoteFunction<R> function) {
        Lock writeLock;
        this.checkState();
        String domainId = null;
        if (this.domain.isPresent()) {
            domainId = (String)this.domain.get().evaluateWithRemoteDomain((deployedDomainId, runtimeToolingService) -> deployedDomainId);
        }
        if (!this.deployed && (writeLock = this.deploymentLock.writeLock()).tryLock()) {
            try {
                if (!this.deployed) {
                    this.deployed = true;
                    this.remoteArtifactId = this.artifactDeployer.deploy(domainId);
                    R r = function.apply(this.remoteArtifactId, (RuntimeToolingService)this.runtimeToolingService.get());
                    return r;
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        Lock readLock = this.deploymentLock.readLock();
        readLock.lock();
        try {
            R r = function.apply(this.remoteArtifactId, (RuntimeToolingService)this.runtimeToolingService.get());
            return r;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    protected LazyValue<ToolingArtifactClassLoader> newToolingArtifactClassLoaderLazyValue() {
        return new LazyValue(() -> this.context.getApplicationClassLoaderFactory().createApplicationClassLoader((ApplicationDescriptor)this.artifactDescriptor, this.artifactResources.getWorkingDirectory(), this.domain.map(parent -> parent.getArtifactClassLoader()).orElse(null)));
    }

    @Override
    protected LazyValue<ToolingApplicationModel> newToolingApplicationModelLazyValue() {
        return new LazyValue(() -> new ToolingApplicationModel(this.domain.map(parent -> parent.getApplicationModel()).orElse(null), new DefaultApplicationModelFactory().createApplicationModel(this.artifactDescriptor, (Set<ExtensionModel>)ImmutableSet.builder().addAll(this.getExtensionModels()).build(), this.getArtifactClassLoader().getClassLoader(), this.domain.map(parent -> ((ApplicationModel)parent.getApplicationModel().getMuleApplicationModel()).getConfigurationProperties()).orElse(this.noFailureConfigurationProperties), this.getProperties()).orElseThrow(() -> new ToolingException(String.format("Couldn't create ApplicationModel from %s", this))), this.getArtifactClassLoader().getClassLoader()));
    }
}

