/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.DefaultApplicationModelFactory;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.AbstractArtifact;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.application.Domain;
import org.mule.tooling.client.internal.application.RemoteDomainInvoker;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;

public class DefaultDomain
extends AbstractArtifact<DomainDescriptor>
implements Domain {
    private ReentrantReadWriteLock deploymentLock = new ReentrantReadWriteLock();

    public DefaultDomain(String id, ArtifactResources artifactResources, DomainDescriptor domainDescriptor, ToolingArtifactContext context, Map<String, String> properties) {
        super(id, artifactResources, domainDescriptor, context, properties);
    }

    @Override
    public DomainDescriptor getDescriptor() {
        return (DomainDescriptor)this.artifactDescriptor;
    }

    @Override
    protected LazyValue<ToolingArtifactClassLoader> newToolingArtifactClassLoaderLazyValue() {
        return new LazyValue(() -> this.context.getDomainClassLoaderFactory().createDomainClassLoader((DomainDescriptor)this.artifactDescriptor, this.artifactResources.getWorkingDirectory()));
    }

    @Override
    protected LazyValue<ToolingApplicationModel> newToolingApplicationModelLazyValue() {
        return new LazyValue(() -> new ToolingApplicationModel(null, new DefaultApplicationModelFactory().createApplicationModel(this.artifactDescriptor, (Set<ExtensionModel>)ImmutableSet.builder().addAll(this.getExtensionModels()).build(), this.getArtifactClassLoader().getClassLoader(), this.noFailureConfigurationProperties, this.getProperties()).orElseThrow(() -> new ToolingException(String.format("Couldn't create ApplicationModel from %s", this))), this.getArtifactClassLoader().getClassLoader()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R evaluateWithRemoteDomain(RemoteDomainInvoker.DomainRemoteFunction<R> function) {
        ReentrantReadWriteLock.WriteLock writeLock;
        this.checkState();
        if (!this.deployed && (writeLock = this.deploymentLock.writeLock()).tryLock()) {
            try {
                if (!this.deployed) {
                    this.deployed = true;
                    this.remoteArtifactId = this.artifactDeployer.deploy(null);
                    R r = function.apply(this.remoteArtifactId, (RuntimeToolingService)this.runtimeToolingService.get());
                    return r;
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        ReentrantReadWriteLock.ReadLock readLock = this.deploymentLock.readLock();
        readLock.lock();
        try {
            R r = function.apply(this.remoteArtifactId, (RuntimeToolingService)this.runtimeToolingService.get());
            return r;
        }
        finally {
            readLock.unlock();
        }
    }
}

