/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.datasense;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.application.Artifact;
import org.mule.tooling.client.internal.application.ToolingApplicationModel;
import org.mule.tooling.client.internal.datasense.ApplicationModelUtils;
import org.mule.tooling.client.internal.metadata.MetadataCache;

public class DataSenseArtifact {
    private final Artifact artifact;
    private final LazyValue<MetadataCache> metadataCache;
    private final MetadataProvider metadataProvider;
    private final Map<String, String> artifactProperties;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final MetadataService apikitMetadataService;
    private final DataSenseArtifact parent;

    public DataSenseArtifact(Artifact artifact, LazyValue<MetadataCache> metadataCache, MetadataProvider metadataProvider, Map<String, String> artifactProperties, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataService apikitMetadataService, DataSenseArtifact parent) {
        this.artifact = artifact;
        this.metadataCache = metadataCache;
        this.metadataProvider = metadataProvider;
        this.artifactProperties = artifactProperties;
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.apikitMetadataService = apikitMetadataService;
        this.parent = parent;
    }

    public MetadataCache getMetadataCache() {
        return (MetadataCache)this.metadataCache.get();
    }

    public boolean hasComponentModel(ComponentLocation componentLocation) {
        return ApplicationModelUtils.findComponentWithLocation(this.artifact.getApplicationModel().getMuleApplicationModel(), componentLocation).isPresent();
    }

    public Optional<DataSenseArtifact> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Map<String, String> getProperties() {
        return this.artifactProperties;
    }

    public List<ExtensionModel> getExtensionModels() {
        return this.artifact.getExtensionModels();
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public ToolingApplicationModel getToolingApplicationModel() {
        return this.artifact.getApplicationModel();
    }

    public ToolingArtifactClassLoader getArtifactClassLoader() {
        return this.artifact.getArtifactClassLoader();
    }

    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }

    public MuleVersion getMinMuleVersion() {
        return this.artifact.getMinMuleVersion();
    }

    public File getRootArtifactFolder() {
        return this.artifact.getRootArtifactFolder();
    }

    public String toString() {
        return this.artifact.toString();
    }

    public MetadataProvider getMetadataProvider(ComponentLocation componentLocation) {
        if (this.getParent().isPresent() && this.getParent().get().hasComponentModel(componentLocation)) {
            return this.getParent().get().getMetadataProvider();
        }
        return this.getMetadataProvider();
    }

    public MetadataService getApikitMetadataService() {
        return this.apikitMetadataService;
    }
}

