/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.metadata.ComponentModelMediator;
import org.mule.tooling.client.internal.metadata.MetadataCache;
import org.mule.tooling.client.internal.metadata.MetadataCachePopulator;
import org.mule.tooling.client.internal.metadata.ToolingMetadataCacheIdGenerator;

public class DefaultToolingMetadataCache
implements MetadataCache {
    private Map<String, MetadataType> metadataTypesCache;
    private Map<String, List<MetadataFailure>> failureMetadataComponentCache;
    private Map<String, MetadataResult<MetadataKeysContainer>> metadataKeysCache;
    private ToolingMetadataCacheIdGenerator cacheIdGenerator;

    public DefaultToolingMetadataCache(Map<String, MetadataType> metadataTypesCache, Map<String, List<MetadataFailure>> failureMetadataComponentCache, Map<String, MetadataResult<MetadataKeysContainer>> metadataKeysCache, ToolingMetadataCacheIdGenerator metadataCacheIdGenerator) {
        this.metadataTypesCache = metadataTypesCache;
        this.failureMetadataComponentCache = failureMetadataComponentCache;
        this.metadataKeysCache = metadataKeysCache;
        this.cacheIdGenerator = metadataCacheIdGenerator;
    }

    @Override
    public MetadataResult<OperationModel> getOperationMetadata(ComponentAst componentAst, Callable<MetadataResult<OperationModel>> resolver) {
        OperationModel operationModel = (OperationModel)componentAst.getModel(OperationModel.class).orElseThrow(() -> new IllegalArgumentException(String.format("Operation model should be present for component: %s", componentAst.getLocation())));
        return this.getComponentMetadata(operationModel, componentAst, resolver);
    }

    @Override
    public MetadataResult<SourceModel> getSourceMetadata(ComponentAst componentAst, Callable<MetadataResult<SourceModel>> resolver) {
        SourceModel sourceModel = (SourceModel)componentAst.getModel(SourceModel.class).orElseThrow(() -> new IllegalArgumentException(String.format("Source model should be present for component: %s", componentAst.getLocation())));
        return this.getComponentMetadata(sourceModel, componentAst, resolver);
    }

    private <T extends ComponentModel> MetadataResult<T> getComponentMetadata(T staticComponentModel, ComponentAst componentAst, Callable<MetadataResult<T>> resolver) {
        String failureComponentKey = this.cacheIdGenerator.getIdForComponentMetadata(componentAst).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't create a metadata cache id for component: %s", componentAst.getLocation())));
        if (this.failureMetadataComponentCache.containsKey(failureComponentKey)) {
            return MetadataResult.failure(this.failureMetadataComponentCache.get(failureComponentKey));
        }
        ComponentModelMediator<T> componentModelMediator = new ComponentModelMediator<T>(this.metadataTypesCache, this.cacheIdGenerator, componentAst, staticComponentModel);
        Optional<T> enrichComponentModel = componentModelMediator.enrichComponentModel();
        if (enrichComponentModel.isPresent()) {
            return MetadataResult.success(enrichComponentModel.get());
        }
        MetadataResult<T> result = this.executeHandling(resolver);
        if (!result.isSuccess()) {
            this.failureMetadataComponentCache.putIfAbsent(failureComponentKey, result.getFailures());
            return result;
        }
        new MetadataCachePopulator<ComponentModel>(this.metadataTypesCache, this.cacheIdGenerator, componentAst, (ComponentModel)result.get()).populateCache();
        return result;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentAst componentAst, Callable<MetadataResult<MetadataKeysContainer>> resolver) {
        return this.cacheIdGenerator.getIdForMetadataKeys(componentAst).map(id -> this.metadataKeysCache.computeIfAbsent((String)id, k -> this.executeHandling(resolver))).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't create a metadata cache id for component: %s", componentAst.getLocation())));
    }

    @Override
    public void dispose(ComponentAst componentAst) {
        Optional<String> componentCacheId = this.cacheIdGenerator.getIdForComponentMetadata(componentAst);
        componentCacheId.ifPresent(cid -> this.failureMetadataComponentCache.keySet().remove(cid));
        componentAst.getModel(ConfigurationModel.class).map(cm -> {
            this.disposeConfig(componentAst);
            return null;
        }).orElseGet(() -> {
            componentAst.getModel(ParameterizedModel.class).ifPresent(pm -> this.disposeTypes(componentAst, pm.getAllParameterModels()));
            return null;
        });
    }

    @Override
    public void invalidateMetadataKeysFor(ComponentAst componentAst) {
        Optional<String> componentKeysCacheId = this.cacheIdGenerator.getIdForMetadataKeys(componentAst);
        componentKeysCacheId.ifPresent(cid -> this.metadataKeysCache.keySet().remove(cid));
    }

    private void disposeConfig(ComponentAst configAst) {
        Optional<String> configId = this.cacheIdGenerator.getIdForComponentMetadata(configAst);
        configId.ifPresent(id -> {
            this.disposeAllConfigRelated((String)id, this.metadataKeysCache);
            this.disposeAllConfigRelated((String)id, this.metadataTypesCache);
        });
    }

    private void disposeAllConfigRelated(String configId, Map<String, ?> externalCache) {
        Set<String> allKeys = externalCache.keySet();
        Set toRemove = allKeys.stream().filter(k -> ToolingMetadataCacheIdGenerator.areRelated(configId, k)).collect(Collectors.toSet());
        externalCache.keySet().removeAll(toRemove);
    }

    private void disposeTypes(ComponentAst component, List<ParameterModel> parameterModels) {
        HashSet typesToRemove = new HashSet();
        component.getModel(HasOutputModel.class).ifPresent(om -> {
            if (om.getOutput().hasDynamicType()) {
                this.cacheIdGenerator.getIdForComponentOutputMetadata(component).ifPresent(typesToRemove::add);
            }
            if (om.getOutputAttributes().hasDynamicType()) {
                this.cacheIdGenerator.getIdForComponentAttributesMetadata(component).ifPresent(typesToRemove::add);
            }
        });
        for (ParameterModel parameterModel : parameterModels) {
            if (!parameterModel.hasDynamicType()) continue;
            this.cacheIdGenerator.getIdForComponentInputMetadata(component, parameterModel.getName()).ifPresent(typesToRemove::add);
        }
        this.metadataTypesCache.keySet().removeAll(typesToRemove);
        this.cacheIdGenerator.getIdForMetadataKeys(component).ifPresent(id -> this.metadataKeysCache.keySet().remove(id));
    }

    private <T> MetadataResult<T> executeHandling(Callable<MetadataResult<T>> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
    }
}

