/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import java.util.List;
import java.util.Map;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.tooling.client.internal.metadata.ToolingMetadataCacheIdGenerator;

public class MetadataCachePopulator<T extends ComponentModel> {
    private ComponentAst componentAst;
    private ToolingMetadataCacheIdGenerator cacheIdGenerator;
    private Map<String, MetadataType> metadataTypesCache;
    private T component;

    public MetadataCachePopulator(Map<String, MetadataType> metadataTypesCache, ToolingMetadataCacheIdGenerator cacheIdGenerator, ComponentAst componentAst, T component) {
        this.metadataTypesCache = metadataTypesCache;
        this.cacheIdGenerator = cacheIdGenerator;
        this.componentAst = componentAst;
        this.component = component;
    }

    public void populateCache() {
        this.component.accept(new ComponentModelVisitor(){

            public void visit(ConstructModel constructModel) {
            }

            public void visit(OperationModel operationModel) {
                operationModel.getParameterGroupModels().stream().forEach(parameterGroupModel -> MetadataCachePopulator.this.populateCacheInputParameters(parameterGroupModel.getParameterModels()));
                MetadataCachePopulator.this.populateCacheOutput(operationModel.getOutput());
                MetadataCachePopulator.this.populateCacheOutputAttributes(operationModel.getOutputAttributes());
            }

            public void visit(SourceModel sourceModel) {
                sourceModel.getParameterGroupModels().stream().forEach(parameterGroupModel -> MetadataCachePopulator.this.populateCacheInputParameters(parameterGroupModel.getParameterModels()));
                sourceModel.getSuccessCallback();
                sourceModel.getErrorCallback();
                MetadataCachePopulator.this.populateCacheOutput(sourceModel.getOutput());
                MetadataCachePopulator.this.populateCacheOutputAttributes(sourceModel.getOutputAttributes());
            }
        });
    }

    private void populateCacheInputParameters(List<ParameterModel> parameterModels) {
        parameterModels.stream().forEach(parameterModel -> {
            if (parameterModel.hasDynamicType()) {
                String idForComponentInputMetadata = this.cacheIdGenerator.getIdForComponentInputMetadata(this.componentAst, parameterModel.getName()).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s parameter name: %s", this.componentAst.getLocation(), parameterModel.getName())));
                this.metadataTypesCache.putIfAbsent(idForComponentInputMetadata, parameterModel.getType());
            }
        });
    }

    private void populateCacheOutput(OutputModel outputModel) {
        if (outputModel.hasDynamicType()) {
            String idForComponentOutputMetadata = this.cacheIdGenerator.getIdForComponentOutputMetadata(this.componentAst).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s output", this.componentAst.getLocation())));
            this.metadataTypesCache.putIfAbsent(idForComponentOutputMetadata, outputModel.getType());
        }
    }

    private void populateCacheOutputAttributes(OutputModel outputModel) {
        if (outputModel.hasDynamicType()) {
            String idForComponentAttributesMetadata = this.cacheIdGenerator.getIdForComponentAttributesMetadata(this.componentAst).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't generate a MetadataCacheId for %s output attributes", this.componentAst.getLocation())));
            this.metadataTypesCache.putIfAbsent(idForComponentAttributesMetadata, outputModel.getType());
        }
    }
}

