/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.metadata;

import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingMetadataCacheIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolingMetadataCacheIdGenerator.class);
    private static final String ENRICHED_PART_SEPARATOR = "#";
    private static final ModelBasedMetadataCacheIdGeneratorFactory cacheIdGeneratorFactory = new ModelBasedMetadataCacheIdGeneratorFactory();
    private MetadataCacheIdGenerator<ComponentAst> delegate;
    private DslResolvingContext dslResolvingContext;

    public static boolean areRelated(String parentValue, String childValue) {
        Pair<String, String> parentSplitInfo = ToolingMetadataCacheIdGenerator.splitInformation(parentValue);
        Pair<String, String> childSplitInfo = ToolingMetadataCacheIdGenerator.splitInformation(childValue);
        if (((String)parentSplitInfo.getFirst()).equals(childSplitInfo.getFirst())) {
            return ((String)childSplitInfo.getSecond()).contains((CharSequence)parentSplitInfo.getSecond());
        }
        return false;
    }

    private static Pair<String, String> splitInformation(String idValue) {
        String valuePart;
        String enrichedPart = "";
        String[] parts = idValue.split(ENRICHED_PART_SEPARATOR);
        if (parts.length == 1) {
            valuePart = parts[0];
        } else {
            enrichedPart = parts[0];
            valuePart = parts[1];
        }
        return new Pair((Object)enrichedPart, (Object)valuePart);
    }

    private String betweenBrackets(String value) {
        return "[" + value + "]";
    }

    public ToolingMetadataCacheIdGenerator(DslResolvingContext context, MetadataCacheIdGeneratorFactory.ComponentLocator<ComponentAst> locator) {
        this.dslResolvingContext = context;
        this.delegate = cacheIdGeneratorFactory.create(context, locator);
    }

    public Optional<String> getIdForComponentOutputMetadata(ComponentAst component) {
        return this.generateMetadataCacheId(component, () -> this.delegate.getIdForComponentOutputMetadata((Object)component));
    }

    public Optional<String> getIdForComponentAttributesMetadata(ComponentAst component) {
        return this.generateMetadataCacheId(component, () -> this.delegate.getIdForComponentAttributesMetadata((Object)component));
    }

    public Optional<String> getIdForComponentInputMetadata(ComponentAst component, String parameterName) {
        return this.generateMetadataCacheId(component, () -> this.delegate.getIdForComponentInputMetadata((Object)component, parameterName));
    }

    public Optional<String> getIdForComponentMetadata(ComponentAst component) {
        return this.generateMetadataCacheId(component, () -> this.delegate.getIdForComponentMetadata((Object)component));
    }

    public Optional<String> getIdForMetadataKeys(ComponentAst component) {
        return this.generateMetadataCacheId(component, () -> this.delegate.getIdForMetadataKeys((Object)component));
    }

    public Optional<String> getIdForGlobalMetadata(ComponentAst component) {
        return this.generateMetadataCacheId(component, () -> this.delegate.getIdForGlobalMetadata((Object)component));
    }

    private Optional<String> generateMetadataCacheId(ComponentAst componentAst, Supplier<Optional<MetadataCacheId>> metadataCacheIdSupplier) {
        return metadataCacheIdSupplier.get().map(metadataCacheId -> {
            Reference idToReturn = new Reference((Object)metadataCacheId.getValue());
            this.getExtensionModel(componentAst).ifPresent(em -> {
                block2: {
                    try {
                        String major = this.getMajor(em.getVersion());
                        idToReturn.set((Object)(this.betweenBrackets(em.getName().toLowerCase()) + "-" + this.betweenBrackets(major) + ENRICHED_PART_SEPARATOR + metadataCacheId.getValue()));
                    }
                    catch (SemverException e) {
                        if (!LOGGER.isErrorEnabled()) break block2;
                        LOGGER.error("Unable to properly create a cache key id for " + componentAst + " ,extension model version does not follow semver, was: " + em.getVersion());
                    }
                }
            });
            return (String)idToReturn.get();
        });
    }

    private Optional<ExtensionModel> getExtensionModel(ComponentAst componentAst) {
        return this.dslResolvingContext.getExtensions().stream().filter(em -> componentAst.getIdentifier().getNamespace().equals(em.getXmlDslModel().getPrefix())).findAny();
    }

    private String getMajor(String version) {
        Semver semver = new Semver(version);
        return semver.getMajor().toString();
    }
}

