/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;

/**
 * Creates a {@link org.mule.datasense.api.metadataprovider.ApplicationModel} from the application.
 *
 * @since 4.0
 */
public interface ApplicationModelFactory {

  /**
   * Creates the {@link ArtifactAst} from the artifact.
   *
   * @param deployableArtifactDescriptor    {@link DeployableArtifactDescriptor} for artifact.
   * @param astXmlParser                    the XML parser to be used for generating the artifact model.
   * @param applicationClassLoader          {@link ClassLoader} for the application to resolve resources.
   * @param configurationPropertiesResolver a function to obtain the resolver that corresponds to the given {@link ArtifactAst}.
   * @return an {@link Optional} {@link ArtifactAst}.
   * @throws Exception if an error happens while generating the {@link ArtifactAst}.
   */
  Optional<ArtifactAst> createApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor,
                                               AstXmlParser parser,
                                               ClassLoader applicationClassLoader,
                                               Function<ArtifactAst, UnaryOperator<String>> configurationPropertiesResolver);

  /**
   * Creates the {@link ArtifactAst} from the artifact.
   *
   * @param deployableArtifactDescriptor    {@link DeployableArtifactDescriptor} for artifact.
   * @param extensionModels                 {@link Set} of {@link ExtensionModel extension models} to be used for generating the
   *                                        application model.
   * @param applicationClassLoader          {@link ClassLoader} for the application to resolve resources.
   * @param configurationPropertiesResolver a function to obtain the resolver that corresponds to the given {@link ArtifactAst}.
   * @param deploymentProperties            {@link Map} with the deployment properties for the artifact.
   * @return an {@link Optional} {@link ArtifactAst}.
   * @throws Exception if an error happens while generating the {@link ArtifactAst}.
   *
   * @deprecated Use
   *             {@link #createApplicationModel(DeployableArtifactDescriptor, AstXmlParser, ClassLoader, ConfigurationProperties, Map)}
   *             instead
   */
  @Deprecated
  Optional<ArtifactAst> createApplicationModel(DeployableArtifactDescriptor deployableArtifactDescriptor,
                                               Set<ExtensionModel> extensionModels,
                                               ClassLoader applicationClassLoader,
                                               Function<ArtifactAst, UnaryOperator<String>> configurationPropertiesResolver,
                                               Map<String, String> deploymentProperties);

}
