/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.agent.RuntimeToolingService;

import java.util.Map;
import java.util.function.Supplier;

/**
 * Creates a {@link ArtifactDeployer}.
 *
 * @since 4.0
 */
public final class RemoteArtifactContextFactory {

  /**
   * @param artifactResources     {@link ArtifactResources} defines the artifact resources. Non null.
   * @param deploymentProperties  {@link Map} deployment properties for the artifact. Non null.
   * @param runtimeToolingService {@link RuntimeToolingService} to be used when context is deployed and disposed. Non null.
   * @return {@link ArtifactDeployer} for doing an operation against a Mule Runtime.
   */
  public static ArtifactDeployer createRemoteArtifactContext(ArtifactResources artifactResources,
                                                             Map<String, String> deploymentProperties,
                                                             Supplier<RuntimeToolingService> runtimeToolingService) {
    requireNonNull(artifactResources, "artifactResources cannot be null");
    requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");

    if (!artifactResources.isRemote()) {
      return new FileSystemArtifactDeployer(artifactResources, runtimeToolingService, deploymentProperties);
    } else {
      return new InputStreamArtifactDeployer(artifactResources, runtimeToolingService, deploymentProperties);
    }
  }

}
