/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.nativelib;

import org.mule.runtime.deployment.model.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;

import java.io.File;
import java.net.URL;

public class ToolingNativeLibraryFinderFactory implements NativeLibraryFinderFactory {

  private File workingDirectory;

  public ToolingNativeLibraryFinderFactory(File workingDirectory) {
    this.workingDirectory = workingDirectory;
  }

  @Override
  public NativeLibraryFinder create(String name, URL[] urls) {
    return new ArtifactCopyNativeLibraryFinder(new File(new File(workingDirectory, name), "temp"), urls);
  }
}
