/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.filter;

import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;

import java.util.Optional;

public class FilterUtils {

  public static Optional<ParameterValue> getParameterConfiguredValue(ParameterizedElementDeclaration parameterizedElementDeclaration,
                                                                     String parameterName) {
    return parameterizedElementDeclaration
        .getParameterGroups()
        .stream()
        .flatMap(pg -> pg.getParameters().stream())
        .filter(p -> p.getName().equals(parameterName))
        .map(ParameterElementDeclaration::getValue)
        .findFirst();
  }

}
