/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.mediator;

import static java.util.Optional.ofNullable;

import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;

import java.util.Optional;

public class ValuesResolverContext {

  private final ComponentElementDeclaration<?> componentElementDeclaration;
  private final ValueProviderModel valueProviderModel;
  private final MetadataKeyPartModelProperty metadataKeyPartModelProperty;

  public ValuesResolverContext(ComponentElementDeclaration<?> componentElementDeclaration,
                               ValueProviderModel valueProviderModel) {
    this.componentElementDeclaration = componentElementDeclaration;
    this.valueProviderModel = valueProviderModel;
    this.metadataKeyPartModelProperty = null;
  }

  public ValuesResolverContext(ComponentElementDeclaration<?> componentElementDeclaration,
                               MetadataKeyPartModelProperty metadataKeyPartModelProperty) {
    this.componentElementDeclaration = componentElementDeclaration;
    this.metadataKeyPartModelProperty = metadataKeyPartModelProperty;
    this.valueProviderModel = null;
  }


  public ComponentElementDeclaration<?> getComponentElementDeclaration() {
    return componentElementDeclaration;
  }

  public Optional<ValueProviderModel> getValueProviderModel() {
    return ofNullable(valueProviderModel);
  }

  public Optional<MetadataKeyPartModelProperty> getMetadataKeyPartModelProperty() {
    return ofNullable(metadataKeyPartModelProperty);
  }

}
