/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import static java.util.Collections.emptyList;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.data.sample.SampleDataProviderModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;

import java.util.List;

public class SampleDataActingParametersValidator extends AbstractActingParametersValidator {

  @Override
  protected String getErrorMessagePrefix(ComponentValidationContext<?> context) {
    return "Unable to resolve SampleData on " + context.getParameterizedModel().getName();
  }

  @Override
  protected List<ActingParameterModel> doGetActingParameters(ComponentValidationContext<?> context) {
    if (context.getEnrichableModel() instanceof HasOutputModel) {
      HasOutputModel model = (HasOutputModel) context.getEnrichableModel();
      return model.getSampleDataProviderModel().map(SampleDataProviderModel::getParameters).orElse(emptyList());
    }
    return emptyList();
  }
}
