/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.values;

import static org.mule.runtime.api.value.ResolvingFailure.Builder.newFailure;
import static org.mule.runtime.api.value.ValueResult.resultFrom;
import static org.mule.tooling.client.internal.utils.FunctionalUtils.executeHandling;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.List;
import java.util.concurrent.Callable;

/**
 * a {@link ValueProviderCache} that does not cache anything
 */
public class NoOpValueProviderCache implements ValueProviderCache {

  @Override
  public ValueResult getValues(ComponentAst componentAst, String parameterName, Callable<ValueResult> callable) {
    return executeHandling(callable, e -> resultFrom(newFailure(e).build()));
  }

  @Override
  public void dispose(ComponentAst componentAst, List<String> parameterNames) {
    // do nothing, there is nothing to dispose.
  }
}
