/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.OutputModel;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class OutputModelMatcher extends TypeSafeMatcher<OutputModel> {

  public static Matcher<OutputModel> from(org.mule.runtime.api.meta.model.OutputModel runtimeOutputModel) {
    if (runtimeOutputModel == null) {
      return nullValue(OutputModel.class);
    }
    return new OutputModelMatcher(runtimeOutputModel);
  }

  private final org.mule.runtime.api.meta.model.OutputModel runtimeOutputModel;

  private OutputModelMatcher(org.mule.runtime.api.meta.model.OutputModel runtimeOutputModel) {
    this.runtimeOutputModel = runtimeOutputModel;
  }

  @Override
  protected boolean matchesSafely(OutputModel item) {
    return runtimeOutputModel.hasDynamicType() == item.hasDynamicType() &&
        runtimeOutputModel.getType().equals(item.getType());

  }

  @Override
  protected void describeMismatchSafely(OutputModel item, Description mismatchDescription) {
    mismatchDescription.appendText("was ").appendText("OutputModel: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("OutputModel: ").appendValue(runtimeOutputModel);
  }
}
