/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.service;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.el.ExpressionLanguageCapabilitiesService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.tooling.client.internal.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceRegistry.class);
    private List<Service> services;
    private LazyValue<ExpressionLanguageMetadataService> expressionLanguageMetadataService;
    private LazyValue<ExpressionLanguageCapabilitiesService> expressionLanguageCapabilitiesService;
    private LazyValue<MetadataService> apikitMetadataService;
    private LazyValue<DefaultExpressionLanguageFactoryService> defaultExpressionLanguageFactoryService;

    public DefaultServiceRegistry(List<Service> services) {
        this.services = new ArrayList<Service>(services);
        this.initServices();
        this.startServices();
    }

    private void initServices() {
        this.expressionLanguageMetadataService = new LazyValue(() -> (ExpressionLanguageMetadataService)this.services.stream().filter(service -> service.getContractName().equals(ExpressionLanguageMetadataService.class.getSimpleName())).findFirst().orElseThrow(() -> new RuntimeException("Weave expression language metadata service cannot be found")));
        this.expressionLanguageCapabilitiesService = new LazyValue(() -> (ExpressionLanguageCapabilitiesService)this.services.stream().filter(service -> service.getContractName().equals(ExpressionLanguageCapabilitiesService.class.getSimpleName())).findFirst().orElseThrow(() -> new RuntimeException("Weave expression language capabilities service cannot be found")));
        this.apikitMetadataService = new LazyValue(() -> (MetadataService)this.services.stream().filter(service -> service.getContractName().equals(MetadataService.class.getSimpleName())).findFirst().orElseThrow(() -> new RuntimeException("Apikit metadata service cannot be found")));
        this.defaultExpressionLanguageFactoryService = new LazyValue(() -> (DefaultExpressionLanguageFactoryService)this.services.stream().filter(service -> service.getContractName().equals(DefaultExpressionLanguageFactoryService.class.getSimpleName())).findFirst().orElseThrow(() -> new RuntimeException("Default Expression Language Factory service cannot be found")));
    }

    private void startServices() {
        for (Service service : this.services) {
            try {
                LifecycleUtils.startIfNeeded((Object)service);
            }
            catch (MuleException e) {
                if (!StringUtils.isEmpty((String)service.getContractName())) {
                    LOGGER.warn(String.format("Failed to start service '%s - %s': %s", service.getName(), service.getContractName(), e.getMessage()), (Throwable)e);
                    continue;
                }
                LOGGER.warn(String.format("Failed to start service '%s': %s", service.getName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.services.forEach(service -> {
            try {
                LifecycleUtils.stopIfNeeded((Object)service);
            }
            catch (MuleException e) {
                LOGGER.warn(String.format("Failed to stop service '%s': %s", service.getName(), e.getMessage()), (Throwable)e);
            }
        });
    }

    @Override
    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return (ExpressionLanguageMetadataService)this.expressionLanguageMetadataService.get();
    }

    @Override
    public ExpressionLanguageCapabilitiesService getExpressionLanguageCapabilitiesService() {
        return (ExpressionLanguageCapabilitiesService)this.expressionLanguageCapabilitiesService.get();
    }

    @Override
    public MetadataService getApikitMetadataService() {
        return (MetadataService)this.apikitMetadataService.get();
    }

    @Override
    public DefaultExpressionLanguageFactoryService getDefaultExpressionLanguageFactoryService() {
        return (DefaultExpressionLanguageFactoryService)this.defaultExpressionLanguageFactoryService.get();
    }
}

