/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.config.api.dsl.model.metadata.DeclarationBasedValueProviderCacheIdGenerator;
import org.mule.runtime.core.internal.locator.ComponentLocator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.value.cache.ValueProviderCacheId;

import java.util.Optional;

public class DeclarationToolingMetadataCacheIdGenerator implements ToolingCacheIdGenerator<ElementDeclaration> {

  private final MetadataCacheIdGenerator<ElementDeclaration> metadataDelegate;
  private final DeclarationBasedValueProviderCacheIdGeneratorAdapter valueProviderDelegate;

  public DeclarationToolingMetadataCacheIdGenerator(MetadataCacheIdGenerator<ElementDeclaration> metadataDelegate,
                                                    // We need this implementation because we need to access protected methods.
                                                    DeclarationBasedValueProviderCacheIdGeneratorAdapter valueProviderDelegate) {
    this.metadataDelegate = metadataDelegate;
    this.valueProviderDelegate = valueProviderDelegate;
  }

  @Override
  public Optional<String> getIdForComponentOutputMetadata(ElementDeclaration component) {
    return metadataDelegate.getIdForComponentOutputMetadata(component).map(MetadataCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForComponentAttributesMetadata(ElementDeclaration component) {
    return metadataDelegate.getIdForComponentAttributesMetadata(component).map(MetadataCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForComponentInputMetadata(ElementDeclaration component, String parameterName) {
    return metadataDelegate.getIdForComponentInputMetadata(component, parameterName).map(MetadataCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForComponentMetadata(ElementDeclaration component) {
    return metadataDelegate.getIdForComponentMetadata(component).map(MetadataCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForMetadataKeys(ElementDeclaration component) {
    return metadataDelegate.getIdForMetadataKeys(component).map(MetadataCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForGlobalMetadata(ElementDeclaration component) {
    return metadataDelegate.getIdForGlobalMetadata(component).map(MetadataCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForResolvedValues(ElementDeclaration component, String parameterName) {
    return valueProviderDelegate.getIdForResolvedValues(component, parameterName).map(ValueProviderCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForResolvedValues(ElementDeclaration component, String parameterName, String targetSelector) {
    return valueProviderDelegate.getIdForResolvedValues(component, parameterName, targetSelector)
        .map(ValueProviderCacheId::getValue);
  }

  @Override
  public Optional<String> getIdForResolvedValuesDependency(ElementDeclaration component) {
    return valueProviderDelegate.getIdForDependency(component).map(ValueProviderCacheId::getValue);
  }

  public static class DeclarationBasedValueProviderCacheIdGeneratorAdapter extends DeclarationBasedValueProviderCacheIdGenerator {

    public DeclarationBasedValueProviderCacheIdGeneratorAdapter(DslResolvingContext context,
                                                                ComponentLocator<ElementDeclaration> locator) {
      super(context, locator);
    }

    @Override
    public Optional<ValueProviderCacheId> getIdForDependency(ElementDeclaration elementDeclaration) {
      return super.getIdForDependency(elementDeclaration);
    }

  }
}
