/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.cache;

import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;

import java.util.concurrent.Callable;

public interface DeclarationMetadataCache {

  /**
   * Gets the source metadata for the given {@link ComponentElementDeclaration}, if not present the {@link Callable} should be
   * called and result stored in order to resolve the metadata.
   *
   * @param componentElementDeclaration of the component for which to get the metadata
   * @param resolver                    the callback that knows how to fetch the metadata on Mule Runtime.
   * @param forceResolution             call the resolver even if there is a value stored in the cache and override it with the
   *                                    new result
   * @return the metadata for the component.
   */
  MetadataResult<ComponentMetadataTypesDescriptor> getComponentMetadata(ComponentElementDeclaration<?> componentElementDeclaration,
                                                                        Callable<MetadataResult<ComponentMetadataTypesDescriptor>> resolver,
                                                                        boolean forceResolution);

  /**
   * Gets the key metadata for the given {@link ElementDeclaration) , if not present the {@link Callable} should be called and
   * result stored in order to resolve the metadata.
   *
   * @param elementDeclaration of the component for which to get the metadata keys
   * @param resolver           the callback that knows how to fetch the metadata on Mule Runtime.
   * @param forceResolution    call the resolver even if there is a value stored in the cache and override it with the new result.
   * @return the metadata for the key.
   */
  MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentElementDeclaration elementDeclaration,
                                                        Callable<MetadataResult<MetadataKeysContainer>> resolver,
                                                        boolean forceResolution);

  /**
   * Gets the key metadata for the given {@link ElementDeclaration) , if not present the {@link Callable} should be called and
   * result stored in order to resolve the metadata.
   *
   *
   * @param parameterizedModel the model to which the resolution of keys would be made.
   * @param elementDeclaration of the component for which to get the metadata keys.
   * @param resolver           the callback that knows how to fetch the metadata on Mule Runtime.
   * @param forceResolution    call the resolver even if there is a value stored in the cache and override it with the new result,
   *                           for partial fetch the upper level entries with the given partial key would be also removed from
   *                           cache.
   * @return the metadata for the key.
   */
  MetadataResult<MetadataKeysContainer> getMetadataKeysPartialFetch(ParameterizedModel parameterizedModel,
                                                                    ComponentElementDeclaration elementDeclaration,
                                                                    Callable<MetadataResult<MetadataKeysContainer>> resolver,
                                                                    boolean forceResolution);

}
