/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.cache;

import static org.mule.runtime.api.value.ResolvingFailure.Builder.newFailure;
import static org.mule.runtime.api.value.ValueResult.resultFrom;
import static org.mule.tooling.client.internal.utils.FunctionalUtils.executeHandling;

import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataTypesDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;

import java.util.concurrent.Callable;

public class NoOpDeclarationCache implements DeclarationValueProviderCache, DeclarationMetadataCache {

  private static final LazyValue<NoOpDeclarationCache> INSTANCE =
      new LazyValue<>(NoOpDeclarationCache::new);

  public static NoOpDeclarationCache noOpDeclarationCache() {
    return INSTANCE.get();
  }

  private NoOpDeclarationCache() {}

  @Override
  public ValueResult getValues(ElementDeclaration elementDeclaration, String parameterName,
                               Callable<ValueResult> callable,
                               boolean forceResolution) {
    return executeHandling(callable, e -> resultFrom(newFailure(e).build()));
  }

  @Override
  public ValueResult getValues(ElementDeclaration elementDeclaration, String parameterName, String targetSelector,
                               Callable<ValueResult> callable, boolean forceResolution) {
    return executeHandling(callable, e -> resultFrom(newFailure(e).build()));
  }

  @Override
  public MetadataResult<ComponentMetadataTypesDescriptor> getComponentMetadata(ComponentElementDeclaration<?> componentElementDeclaration,
                                                                               Callable<MetadataResult<ComponentMetadataTypesDescriptor>> resolver,
                                                                               boolean forceResolution) {
    return executeHandling(resolver, e -> MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent()));
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeys(ComponentElementDeclaration elementDeclaration,
                                                               Callable<MetadataResult<MetadataKeysContainer>> resolver,
                                                               boolean forceResolution) {
    return executeHandling(resolver, e -> MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys()));
  }

  @Override
  public MetadataResult<MetadataKeysContainer> getMetadataKeysPartialFetch(ParameterizedModel parameterizedModel,
                                                                           ComponentElementDeclaration elementDeclaration,
                                                                           Callable<MetadataResult<MetadataKeysContainer>> resolver,
                                                                           boolean forceResolution) {
    return executeHandling(resolver, e -> MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys()));
  }

}
