/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.filter.exception;

/**
 * Exception to be thrown when filtering a MultiLevel result and the values given to find the requested level do not match the
 * ones resolved.
 */
public class UnknownLevelValueException extends RuntimeException {

  private final String parameterName;
  private final String parameterValue;

  public UnknownLevelValueException(String parameterName, String parameterValue) {
    this.parameterName = parameterName;
    this.parameterValue = parameterValue;
  }

  public String getParameterName() {
    return parameterName;
  }

  public String getParameterValue() {
    return parameterValue;
  }
}
