/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.mediator.resolver;

import static org.mule.runtime.api.value.ValueResult.resultFrom;

import org.mule.runtime.api.meta.model.parameter.FieldValueProviderModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.session.RemoteSessionExecutor;
import org.mule.tooling.client.internal.session.cache.DeclarationMetadataCache;
import org.mule.tooling.client.internal.session.cache.DeclarationValueProviderCache;
import org.mule.tooling.client.internal.session.filter.FieldValueFilter;
import org.mule.tooling.client.internal.session.filter.MetadataKeyFilter;
import org.mule.tooling.client.internal.session.filter.ValueFilter;

public class ValuesResolverFactory {

  private final RemoteSessionExecutor remoteSessionExecutor;
  private final RuntimeToolingService runtimeToolingService;
  private final DeclarationValueProviderCache valueProviderCache;
  private final DeclarationMetadataCache metadataCache;
  private final ValueFilter valueFilter;
  private final MetadataKeyFilter metadataKeyFilter;
  private final FieldValueFilter fieldValueFilter;

  public ValuesResolverFactory(RemoteSessionExecutor remoteSessionExecutor,
                               RuntimeToolingService runtimeToolingService,
                               DeclarationValueProviderCache valueProviderCache,
                               DeclarationMetadataCache metadataCache,
                               ValueFilter valueFilter,
                               MetadataKeyFilter metadataKeyFilter,
                               FieldValueFilter fieldValueFilter) {
    this.runtimeToolingService = runtimeToolingService;
    this.remoteSessionExecutor = remoteSessionExecutor;
    this.valueProviderCache = valueProviderCache;
    this.metadataCache = metadataCache;
    this.valueFilter = valueFilter;
    this.metadataKeyFilter = metadataKeyFilter;
    this.fieldValueFilter = fieldValueFilter;
  }

  public ValuesResolver createValueProviderResolver(ParameterizedElementDeclaration elementDeclaration,
                                                    ValueProviderModel valueProviderModel,
                                                    boolean ignoreCache) {
    return new ValueProviderResolver(
                                     s -> remoteSessionExecutor.withRemoteDeclarationSession(
                                                                                             id -> s.apply(runtimeToolingService,
                                                                                                           id),
                                                                                             e -> resultFrom(ResolvingFailure.Builder
                                                                                                 .newFailure(e)
                                                                                                 .build())),
                                     ignoreCache, elementDeclaration, valueProviderModel, valueProviderCache, valueFilter);
  }

  public ValuesResolver createMetadataKeyResolver(ComponentElementDeclaration<?> componentElementDeclaration,
                                                  MetadataKeyPartModelProperty metadataKeyPartModelProperty,
                                                  boolean ignoreCache) {
    return new MetadataKeyResolver(
                                   s -> remoteSessionExecutor.withRemoteDeclarationSession(
                                                                                           id -> s.apply(runtimeToolingService,
                                                                                                         id),
                                                                                           e -> org.mule.runtime.api.metadata.resolving.MetadataResult
                                                                                               .failure(MetadataFailure.Builder
                                                                                                   .newFailure(e)
                                                                                                   .onKeys())),
                                   ignoreCache, componentElementDeclaration, metadataKeyPartModelProperty, metadataCache,
                                   metadataKeyFilter);
  }

  public ValuesResolver createFieldValueProviderResolver(ParameterizedElementDeclaration elementDeclaration,
                                                         FieldValueProviderModel fieldValueProviderModel,
                                                         boolean ignoreCache) {
    return new FieldValueProviderResolver(
                                          s -> remoteSessionExecutor.withRemoteDeclarationSession(
                                                                                                  id -> s
                                                                                                      .apply(runtimeToolingService,
                                                                                                             id),
                                                                                                  e -> resultFrom(ResolvingFailure.Builder
                                                                                                      .newFailure(e)
                                                                                                      .build())),
                                          ignoreCache, elementDeclaration, fieldValueProviderModel, valueProviderCache,
                                          fieldValueFilter);
  }

}
