/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;

public abstract class AbstractSessionCallValidationContext<T extends ParameterizedModel & EnrichableModel> {

  private final ExtensionModel extensionModel;
  protected final T model;

  AbstractSessionCallValidationContext(ExtensionModel extensionModel,
                                       T model) {
    this.extensionModel = extensionModel;
    this.model = model;
  }

  public ExtensionModel getExtensionModel() {
    return extensionModel;
  }

  public ParameterizedModel getParameterizedModel() {
    return model;
  }

  public EnrichableModel getEnrichableModel() {
    return model;
  }

}
