/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import static java.lang.String.format;
import static org.mule.tooling.client.internal.session.validation.SessionCallValidator.INVALID_PARAMETER;

import org.mule.runtime.api.meta.model.parameter.ParameterModel;

import java.util.Optional;

public class ParameterExistsValidator implements Validators.ComponentValidator {

  private String parameterName;
  private ParameterModel parameterModel;

  public ParameterExistsValidator(String parameterName) {
    this.parameterName = parameterName;
  }

  @Override
  public void validate(ComponentValidationContext<?> context) throws SessionCallValidationException {
    Optional<org.mule.runtime.api.meta.model.parameter.ParameterModel> parameterModel =
        context.getParameterizedModel()
            .getAllParameterModels()
            .stream()
            .filter(p -> p.getName().equals(parameterName))
            .findAny();

    if (!parameterModel.isPresent()) {
      throw new SessionCallValidationException(
                                               format("Parameter: '%s' not found in Model: '%s' for extension: '%s'",
                                                      parameterName,
                                                      context.getComponentDeclaration().getName(),
                                                      context.getComponentDeclaration().getDeclaringExtension()),
                                               "ParameterModel not found",
                                               INVALID_PARAMETER);
    }
    this.parameterModel = parameterModel.get();
  }

  public ParameterModel getParameterModel() {
    if (parameterModel == null) {
      throw new RuntimeException("Model is not yet validated");
    }
    return parameterModel;
  }
}
