/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.utils;

import org.mule.tooling.api.sampledata.SampleDataMessageModelFailure;
import org.mule.tooling.api.sampledata.SampleDataMessageModelResult;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataFailure;
import org.mule.tooling.client.api.sampledata.ComponentSampleDataResult;

public class SampleDataUtils {

  public static ComponentSampleDataResult toComponentSampleDataResult(SampleDataMessageModelResult sampleDataMessageModelResult) {
    if (sampleDataMessageModelResult.isSuccess()) {
      return new ComponentSampleDataResult(sampleDataMessageModelResult.getSampleData().get());
    }
    return new ComponentSampleDataResult(toComponentSampleDataFailure(sampleDataMessageModelResult.getFailure().get()));
  }

  private static ComponentSampleDataFailure toComponentSampleDataFailure(SampleDataMessageModelFailure sampleDataFailure) {
    return new ComponentSampleDataFailure(sampleDataFailure.getMessage(), sampleDataFailure.getReason(),
                                          sampleDataFailure.getFailureCode());
  }
}
