/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.ToolingArtifactContext;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;

/**
 * Responsible for handling Artifact resources and life cycle.
 *
 * @since 4.1
 */
public interface Artifact extends Disposable {

  /**
   * @return unique identifier for this artifact.
   */
  String getId();

  /**
   * @return a name for this artifact.
   */
  String getArtifactName();

  /**
   * @return the root folder of the artifact.
   */
  File getRootArtifactFolder();

  /**
   * @return {@link Map} with properties for this artifact.
   */
  Map<String, String> getProperties();

  /**
   * @return {@link URL} from which the content of the artifact.
   */
  URL getArtifactUrlContent();

  /**
   * @return builds the {@link ToolingApplicationModel} for the artifact.
   */
  ToolingApplicationModel getApplicationModel();

  /**
   * @return collects the list of {@link ExtensionModel} for the artifact.
   */
  List<ExtensionModel> getExtensionModels();

  /**
   * @return the {@link ToolingArtifactClassLoader} for the artifact.
   */
  ToolingArtifactClassLoader getArtifactClassLoader();

  /**
   * Sets the {@link ToolingArtifactContext} to be used by this {@link Artifact}. This means that if the Runtime Tooling Service
   * API has changed and it was cached the remote artifact deployed it will be deployed again.
   *
   * @param context {@link ToolingArtifactContext} to be used by this {@link Artifact}
   */
  void setContext(ToolingArtifactContext context);

  /**
   * @return {@link ArtifactType}, could be a domain or application.
   */
  ArtifactType getArtifactType();

  /**
   * Resolves the effective min Mule version required by this artifact which is defined by the biggest value of minMuleVersion
   * from the descriptor and all the plugins descriptor that this artifact depends on.
   *
   * @return effective min Mule version.
   */
  MuleVersion getMinMuleVersion();

}
