/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.tooling.agent.RuntimeToolingService;

/**
 * Invokes operations on a Mule Runtime application.
 *
 * @since 4.0
 */
public interface RemoteApplicationInvoker {

  /**
   * Evaluates the given function in the context of a remote application from Mule Runtime. If the application has not been
   * deployed yet, it will deploy it first and then call the function with the generated applicationId that is passed to the
   * function as parameter.
   * <p/>
   * If the application was already deployed as there was cached an applicationId but the function throws a
   * {@link org.mule.tooling.client.api.exception.NoSuchApplicationException} it will do a deploy and invoke the function.
   *
   * @param function to be executed against a deployed application.
   * @param <R>      the type for the result of the function.
   * @return a result of type {@code <R>}
   */
  <R> R evaluateWithRemoteApplication(ApplicationRemoteFunction<R> function);

  /**
   * A function that receives the applicationId from the application deploy on Mule Runtime and the service to invoke operations
   * remotely on Mule Runtime.
   *
   * @param <R> type of the result for this function.
   */
  @FunctionalInterface
  interface ApplicationRemoteFunction<R> {

    /**
     * Applies a remote operation to an application deployed on Mule Runtime using a {@link RuntimeToolingService}.
     *
     * @param applicationId the id for the application deployed on Mule Runtime.
     * @return the function result
     */
    R apply(String applicationId, RuntimeToolingService runtimeToolingService);

  }

}
