/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.metadata;

import org.mule.tooling.client.api.exception.ToolingException;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

import org.slf4j.MDC;

/**
 * {@link MetadataCacheStorageMapWrapperFactory} that delegates on another instance by reflection given that it's class was loaded
 * by another classloader.
 */
@Deprecated
public class MetadataCacheStorageMapWrapperFactoryProxy implements MetadataCacheStorageMapWrapperFactory {

  private Object proxyTarget;

  public MetadataCacheStorageMapWrapperFactoryProxy(Object proxyTarget) {
    this.proxyTarget = proxyTarget;
  }

  @Override
  public Map<String, Object> create(String toolingArtifactId, URL artifactContentUrl, Map<String, String> properties) {
    try {
      Method method = proxyTarget.getClass().getMethod("create", String.class, URL.class, Map.class);
      method.setAccessible(true);
      return new MDCAwareMap((Map<String, Object>) method.invoke(proxyTarget, toolingArtifactId, artifactContentUrl, properties),
                             proxyTarget.getClass().getClassLoader());
    } catch (Exception e) {
      throw new ToolingException("Error while calling proxy method con client code", e);
    }
  }

  private static class MDCAwareMap implements Map<String, Object> {

    private Method mdcSetContextMapMethod;
    private Map<String, Object> delegate;

    public MDCAwareMap(Map<String, Object> delegate, ClassLoader targetClassLoader)
        throws ClassNotFoundException, NoSuchMethodException {
      this.mdcSetContextMapMethod = targetClassLoader.loadClass(MDC.class.getName()).getMethod("setContextMap", Map.class);
      this.delegate = delegate;
    }

    private <T> T populatingMDC(Supplier<T> callable) {
      try {
        mdcSetContextMapMethod.invoke(null, MDC.getCopyOfContextMap());
      } catch (IllegalAccessException | InvocationTargetException e) {
        throw new ToolingException("Could not populate logging MDC", e);
      }
      return callable.get();
    }

    private void populatingMDC(Runnable runnable) {
      try {
        mdcSetContextMapMethod.invoke(null, MDC.getCopyOfContextMap());
      } catch (IllegalAccessException | InvocationTargetException e) {
        throw new ToolingException("Could not populate logging MDC", e);
      }
      runnable.run();
    }

    @Override
    public int size() {
      return populatingMDC(() -> delegate.size());
    }

    @Override
    public boolean isEmpty() {
      return populatingMDC(() -> delegate.isEmpty());
    }

    @Override
    public boolean containsKey(Object key) {
      return populatingMDC(() -> delegate.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
      return populatingMDC(() -> delegate.containsValue(value));
    }

    @Override
    public Object get(Object key) {
      return populatingMDC(() -> delegate.get(key));
    }

    @Override
    public Object put(String key, Object value) {
      return populatingMDC(() -> delegate.put(key, value));
    }

    @Override
    public Object remove(Object key) {
      return populatingMDC(() -> delegate.remove(key));
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
      populatingMDC(() -> delegate.putAll(m));
    }

    @Override
    public void clear() {
      populatingMDC(() -> delegate.clear());
    }

    @Override
    public Set<String> keySet() {
      return populatingMDC(() -> delegate.keySet());
    }

    @Override
    public Collection<Object> values() {
      return populatingMDC(() -> delegate.values());
    }

    @Override
    public Set<Entry<String, Object>> entrySet() {
      return populatingMDC(() -> delegate.entrySet());
    }

  }

}
