/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session;

import static java.util.stream.Collectors.toList;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.TopLevelParameterDeclaration;
import org.mule.tooling.client.api.descriptors.dependency.Dependency;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Holds the configuration for a {@link DefaultDeclarationSession}.
 */
public class DeclarationSessionConfig {

  private final List<ConfigurationElementDeclaration> configurationElementDeclarations;
  private final List<TopLevelParameterDeclaration> globalParameterDeclarations;
  private final List<Dependency> dependencies;
  private final Map<String, String> sessionProperties;

  public DeclarationSessionConfig(List<ConfigurationElementDeclaration> configurationElementDeclarations,
                                  List<TopLevelParameterDeclaration> globalParameterDeclarations,
                                  List<Dependency> dependencies,
                                  Map<String, String> sessionProperties) {
    this.configurationElementDeclarations = configurationElementDeclarations;
    this.globalParameterDeclarations = globalParameterDeclarations;
    this.dependencies = unreferencedDependencies(dependencies);
    this.sessionProperties = new HashMap<>(sessionProperties);
  }

  public List<ConfigurationElementDeclaration> getConfigurationElementDeclarations() {
    return configurationElementDeclarations;
  }

  public List<TopLevelParameterDeclaration> getGlobalParameterDeclarations() {
    return globalParameterDeclarations;
  }

  public List<Dependency> getDependencies() {
    return unreferencedDependencies(dependencies);
  }

  public Map<String, String> getSessionProperties() {
    return sessionProperties;
  }

  private List<Dependency> unreferencedDependencies(List<Dependency> dependencies) {
    return dependencies.stream().map(Dependency::clone).collect(toList());
  }

}
