/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.filter;

import static java.util.Collections.emptySet;
import static org.mule.tooling.client.internal.session.filter.FilterUtils.getParameterConfiguredValue;

import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterSimpleValueExtractor;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MetadataKeyFilter {

  public Set<MetadataKey> filter(String parameterName, ParameterizedElementDeclaration parameterizedElementDeclaration,
                                 Set<MetadataKey> metadataKeys) {
    Map<String, Set<MetadataKey>> metadataKeysByPart = new HashMap<>();
    try {
      filterMetadataKeys(metadataKeysByPart, metadataKeys, parameterizedElementDeclaration);
    } catch (MissingLevelException e) {
      Set<MetadataKey> level = metadataKeysByPart.get(parameterName);
      if (level == null) {
        throw e;
      }
      return level;
    }
    return emptySet();
  }

  private void filterMetadataKeys(Map<String, Set<MetadataKey>> metadataKeysByPart, Set<MetadataKey> metadataKeys,
                                  ParameterizedElementDeclaration parameterizedElementDeclaration) {
    final Optional<String> optionalKeyPart = metadataKeys.stream().findFirst().map(MetadataKey::getPartName);
    if (!optionalKeyPart.isPresent()) {
      return;
    }
    String keyPart = optionalKeyPart.get();

    metadataKeysByPart.put(keyPart, metadataKeys);

    final Optional<String> optionalKeyPartConfiguredValue =
        getParameterConfiguredValue(parameterizedElementDeclaration, keyPart)
            .map(ParameterSimpleValueExtractor::extractSimpleValue);

    if (!optionalKeyPartConfiguredValue.isPresent()) {
      throw new MissingLevelException(keyPart);
    } else {
      final String keyPartConfiguredValue = optionalKeyPartConfiguredValue.get();

      final Optional<MetadataKey> matchingKey =
          metadataKeys.stream().filter(k -> k.getId().equals(keyPartConfiguredValue)).findFirst();

      if (matchingKey.isPresent()) {
        filterMetadataKeys(metadataKeysByPart, matchingKey.get().getChilds(), parameterizedElementDeclaration);
      } else {
        throw new UnknownLevelValueException(keyPart, keyPartConfiguredValue);
      }
    }
  }


}
