/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.filter.exception;

/**
 * Exception to be thrown when filtering a MultiLevel result and a previous level is missing.
 */
public class MissingLevelException extends RuntimeException {

  private String missingParameterName;

  public MissingLevelException(String missingParameterName) {
    super();
    this.missingParameterName = missingParameterName;
  }

  public String getMissingParameterName() {
    return missingParameterName;
  }
}
