/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import static org.apache.commons.lang3.exception.ExceptionUtils.getStackTrace;
import static org.mule.runtime.api.metadata.resolving.FailureCode.INVALID_METADATA_KEY;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyDeclarationResolver;
import org.mule.runtime.module.tooling.internal.artifact.metadata.MetadataKeyResult;

import java.util.Optional;

public class ComponentMetadataKeyValidator implements Validators.ComponentValidator {

  private ComponentElementDeclaration componentElementDeclaration;

  public ComponentMetadataKeyValidator(ComponentElementDeclaration componentElementDeclaration) {
    this.componentElementDeclaration = componentElementDeclaration;
  }

  @Override
  public void validate(ComponentValidationContext<?> context) throws SessionCallValidationException {
    Optional<ComponentModel> componentModelOptional = context.getComponentModel();
    if (componentModelOptional.isPresent()) {
      try {
        MetadataKeyResult metadataKeyResult =
            new MetadataKeyDeclarationResolver(componentModelOptional.get(),
                                               componentElementDeclaration)
                                                   .resolveKeyResult();
        if (!metadataKeyResult.isComplete()) {
          throw new SessionCallValidationException(metadataKeyResult.getPartialReason(),
                                                   metadataKeyResult.getPartialReason(),
                                                   INVALID_METADATA_KEY.getName());
        }
      } catch (Exception e) {
        throw new SessionCallValidationException(e.getMessage(),
                                                 getStackTrace(e), INVALID_METADATA_KEY.getName());
      }
    }
  }
}
