/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import static java.util.Optional.empty;
import static java.util.Optional.ofNullable;
import static java.util.Optional.of;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;

import java.util.Optional;

public class ComponentValidationContext<T extends ParameterizedModel & EnrichableModel>
    extends AbstractSessionCallValidationContext<T> {

  private final ConfigurationModel configurationModel;
  private final ConfigurationElementDeclaration referencedConfig;
  private final ParameterizedElementDeclaration componentDeclaration;

  ComponentValidationContext(ExtensionModel extensionModel,
                             ConfigurationModel configurationModel,
                             ConfigurationElementDeclaration referencedConfig,
                             ParameterizedElementDeclaration componentDeclaration,
                             T model) {
    super(extensionModel, model);
    this.configurationModel = configurationModel;
    this.referencedConfig = referencedConfig;
    this.componentDeclaration = componentDeclaration;
  }

  // This can be null because we may be talking about a component with no config
  public Optional<ConfigurationModel> getConfigurationModel() {
    return ofNullable(configurationModel);
  }

  // This can be null because we may be talking about a component with no config
  public Optional<ConfigurationElementDeclaration> getReferencedConfig() {
    return ofNullable(referencedConfig);
  }

  public ParameterizedElementDeclaration getComponentDeclaration() {
    return componentDeclaration;
  }

  public Optional<ComponentModel> getComponentModel() {
    if (model instanceof ComponentModel) {
      ComponentModel componentModel = (ComponentModel) model;
      return of(componentModel);
    }
    return empty();
  }
}
