/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;

public class ConfigValidationContext extends AbstractSessionCallValidationContext<ConfigurationModel> {

  private final ConfigurationElementDeclaration configurationElementDeclaration;

  ConfigValidationContext(ExtensionModel extensionModel,
                          ConfigurationModel model,
                          ConfigurationElementDeclaration configurationElementDeclaration) {
    super(extensionModel, model);
    this.configurationElementDeclaration = configurationElementDeclaration;
  }

  public ConfigurationElementDeclaration getConfigDeclaration() {
    return this.configurationElementDeclaration;
  }

  public ConfigurationModel getConfigurationModel() {
    return this.model;
  }
}
