/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

public class SessionCallValidationException extends Exception {

  private final String reason;
  private final String failureCode;

  public SessionCallValidationException(String message, String reason, String failureCode) {
    super(message);
    this.reason = reason;
    this.failureCode = failureCode;
  }

  public String getReason() {
    return reason;
  }

  public String getFailureCode() {
    return failureCode;
  }

}
