/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.session.validation;

import static java.util.Collections.emptyList;

import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;

import java.util.List;

public class ValueProviderActingParametersValidator extends AbstractActingParametersValidator {

  private final String providedParameter;

  public ValueProviderActingParametersValidator(String providedParameter) {
    this.providedParameter = providedParameter;
  }

  @Override
  protected String getErrorMessagePrefix(ComponentValidationContext<?> context) {
    return "Unable to resolve values for parameter: " + providedParameter;
  }

  @Override
  protected List<ActingParameterModel> doGetActingParameters(ComponentValidationContext<?> context) {
    return context.getParameterizedModel()
        .getAllParameterModels()
        .stream()
        .filter(pm -> pm.getName().equals(providedParameter))
        .findAny()
        .flatMap(ParameterModel::getValueProviderModel)
        .map(ValueProviderModel::getParameters)
        .orElse(emptyList());
  }

}
