/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.utils;

import static java.util.Collections.emptySet;
import static org.codehaus.plexus.util.ExceptionUtils.getStackTrace;
import static org.mule.runtime.extension.api.values.ValueResolvingException.UNKNOWN;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.tooling.client.api.value.ResolvingFailure;
import org.mule.tooling.client.api.value.Value;
import org.mule.tooling.client.api.value.ValueResult;

import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletionException;

public class ValueUtils {

  private static final String DEPLOYMENT = "DEPLOYMENT";

  public static ValueResult toValueResultDTO(org.mule.runtime.api.value.ValueResult valueResult) {
    HashSet<Value> values = new HashSet<>();
    for (org.mule.runtime.api.value.Value value : valueResult.getValues()) {
      values.add(toValueDTO(value));
    }

    return new ValueResult(values, toResolvingFailureDTO(valueResult.getFailure()));
  }

  public static ValueResult toFailureValueResultDTO(Throwable t) {

    String failureCode = UNKNOWN;
    if (t instanceof CompletionException) {
      if (t.getCause() instanceof DeploymentException) {
        failureCode = DEPLOYMENT;
      }
    }

    return new ValueResult(emptySet(), new ResolvingFailure(t.getMessage(), getStackTrace(t), failureCode));
  }

  private static Value toValueDTO(org.mule.runtime.api.value.Value value) {
    HashSet<Value> children = new HashSet<>();
    for (org.mule.runtime.api.value.Value child : value.getChilds()) {
      children.add(toValueDTO(child));
    }

    return new Value(value.getId(), value.getDisplayName(), value.getPartName(), children);
  }

  private static ResolvingFailure toResolvingFailureDTO(Optional<org.mule.runtime.api.value.ResolvingFailure> resolvingFailureOptional) {
    if (!resolvingFailureOptional.isPresent()) {
      return null;
    }

    org.mule.runtime.api.value.ResolvingFailure resolvingFailure = resolvingFailureOptional.get();

    return new ResolvingFailure(resolvingFailure.getMessage(), resolvingFailure.getReason(), resolvingFailure.getFailureCode());
  }

}
