/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.hamcrest;

import static org.hamcrest.CoreMatchers.nullValue;

import org.mule.tooling.client.api.extension.model.connection.ConnectionManagementType;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ConnectionManagementTypeMatcher extends TypeSafeMatcher<ConnectionManagementType> {

  public static Matcher<ConnectionManagementType> from(org.mule.runtime.api.meta.model.connection.ConnectionManagementType runtimeConnectionManagementType) {
    if (runtimeConnectionManagementType == null) {
      return nullValue(ConnectionManagementType.class);
    }
    return new ConnectionManagementTypeMatcher(runtimeConnectionManagementType);
  }

  private final org.mule.runtime.api.meta.model.connection.ConnectionManagementType runtimeConnectionManagementType;

  private ConnectionManagementTypeMatcher(org.mule.runtime.api.meta.model.connection.ConnectionManagementType runtimeConnectionManagementType) {
    this.runtimeConnectionManagementType = runtimeConnectionManagementType;
  }

  @Override
  protected boolean matchesSafely(ConnectionManagementType item) {
    switch (runtimeConnectionManagementType) {
      case NONE:
        return item.isNone();
      case CACHED:
        return item.isCached();
      case POOLING:
        return item.isPooling();
    }
    return false;
  }


  @Override
  protected void describeMismatchSafely(ConnectionManagementType item, Description mismatchDescription) {
    mismatchDescription.appendText("was ConnectionManagementType: ").appendValue(item);
  }

  @Override
  public void describeTo(Description description) {
    description.appendText("ConnectionManagementType: ").appendValue(runtimeConnectionManagementType);
  }
}
